/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.r2mo.dbe.mybatisplus.generator.AbstractGenProcessor;
import io.r2mo.dbe.mybatisplus.generator.GenConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenProcessorService
extends AbstractGenProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenProcessorService.class);

    GenProcessorService() {
    }

    @Override
    public void generate(Class<?> entity, GenConfig config) {
        try {
            Configuration cfg = this.getConfigurationFromDependency();
            Map<String, Object> dataModel = this.getDataParameters(entity);
            Template mapperTemplate = cfg.getTemplate("service-interface.ftl");
            String mapperInterfaceName = this.getClassName(entity) + "Service";
            Path packagePath = this.generateMapperPath(config);
            Path mapperInterfacePath = packagePath.resolve(mapperInterfaceName + ".java");
            try (BufferedWriter writer = Files.newBufferedWriter(mapperInterfacePath, new OpenOption[0]);){
                mapperTemplate.process(dataModel, (Writer)writer);
                log.info("[ GEN ] Mapper: " + String.valueOf(mapperInterfacePath) + " generated successfully.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Path generateMapperPath(GenConfig config) throws IOException {
        String mapperPackageName;
        String basePackageName = config.getBasePackage().getName();
        Path provider = config.outProvider();
        Path packagePath = provider.resolve((mapperPackageName = basePackageName + ".service").replace(".", "/"));
        if (!Files.exists(packagePath, new LinkOption[0])) {
            Files.createDirectories(packagePath, new FileAttribute[0]);
            log.info("[ GEN ] Directory created: " + String.valueOf(packagePath));
        }
        return packagePath;
    }
}

