/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.spi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import io.r2mo.base.dbe.syntax.QLeaf;
import io.r2mo.base.dbe.syntax.QSorter;
import io.r2mo.spi.SPI;
import io.r2mo.typed.cc.Cc;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class MetaTable<T> {
    private static final Cc<String, MetaTable<?>> CCT_META = Cc.open();
    private final ConcurrentMap<String, String> f2c = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> c2f = new ConcurrentHashMap<String, String>();

    private MetaTable(Class<T> entityCls) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityCls);
        tableInfo.getFieldList().forEach(field -> {
            this.f2c.put(field.getProperty(), field.getColumn());
            this.c2f.put(field.getColumn(), field.getProperty());
        });
    }

    static <T> MetaTable<T> of(Class<T> clazz) {
        return (MetaTable)CCT_META.pick(() -> new MetaTable(clazz), (Object)clazz.getName());
    }

    String vColumn(String field) {
        if (!this.f2c.containsKey(field)) {
            throw new UnsupportedOperationException("[ R2MO ] field -> column, \u5b57\u6bb5\u5bf9\u5e94\u7684\u5217\u4e0d\u5b58\u5728: " + field);
        }
        return this.f2c.getOrDefault(field, null);
    }

    String vProperty(String column) {
        if (!this.c2f.containsKey(column)) {
            throw new UnsupportedOperationException("[ R2MO ] column -> field, \u5217\u5bf9\u5e94\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728: " + column);
        }
        return this.c2f.getOrDefault(column, null);
    }

    void in(QLeaf leaf, QueryWrapper<T> query) {
        Object value = leaf.value();
        String column = this.vColumn(leaf.field());
        if (value instanceof Collection) {
            query.in((Object)column, (Collection)value);
        } else {
            Collection values = SPI.V_UTIL.toCollection(value);
            query.in((Object)column, values);
        }
    }

    void orderBy(QueryWrapper<T> query, QSorter sorter) {
        if (Objects.isNull(sorter)) {
            return;
        }
        sorter.item().forEach(kv -> {
            boolean isAsc = (Boolean)kv.value();
            String field = (String)kv.key();
            String column = this.vColumn(field);
            if (isAsc) {
                query.orderByAsc((Object)column);
            } else {
                query.orderByDesc((Object)column);
            }
        });
    }

    Map<String, Object> vColumn(Map<String, Object> condition) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        condition.forEach((field, value) -> {
            String column = this.vColumn((String)field);
            columnMap.put(column, value);
        });
        return columnMap;
    }

    List<String> vColumn(List<String> properties) {
        return properties.stream().map(this::vColumn).toList();
    }
}

