/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.core.typehandler;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.BINARY, JdbcType.OTHER})
@MappedTypes(value={UUID.class})
public class TypedUUIDHandler
extends BaseTypeHandler<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypedUUIDHandler.class);

    private static UUID parseUuidLenient(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        String str = s.trim();
        if (str.isEmpty()) {
            return null;
        }
        String hex32 = str.replace("-", "");
        if (hex32.length() == 32) {
            try {
                long msb = new BigInteger(hex32.substring(0, 16), 16).longValue();
                long lsb = new BigInteger(hex32.substring(16), 16).longValue();
                return new UUID(msb, lsb);
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            return UUID.fromString(str);
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static byte[] uuidToBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private static UUID bytesToUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long msb = bb.getLong();
        long lsb = bb.getLong();
        return new UUID(msb, lsb);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter instanceof UUID) {
            UUID uuid = (UUID)parameter;
            this.writeUuid(ps, i, uuid, jdbcType);
            return;
        }
        if (parameter instanceof CharSequence) {
            CharSequence cs = (CharSequence)parameter;
            UUID uuid = TypedUUIDHandler.parseUuidLenient(cs.toString());
            this.writeUuid(ps, i, uuid, jdbcType);
            return;
        }
        if (parameter instanceof byte[]) {
            byte[] bytes = (byte[])parameter;
            if (bytes.length != 16) {
                throw new SQLException("UUID binary must be 16 bytes, actual=" + bytes.length);
            }
            UUID uuid = TypedUUIDHandler.bytesToUuid(bytes);
            this.writeUuid(ps, i, uuid, jdbcType);
            return;
        }
        if (parameter != null) {
            UUID uuid = TypedUUIDHandler.parseUuidLenient(parameter.toString());
            this.writeUuid(ps, i, uuid, jdbcType);
            return;
        }
        throw new SQLException("Null UUID is not allowed in setNonNullParameter");
    }

    public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                ps.setNull(i, 12);
            } else {
                switch (jdbcType) {
                    case BINARY: {
                        ps.setNull(i, -2);
                        break;
                    }
                    case OTHER: {
                        ps.setNull(i, 1111);
                        break;
                    }
                    default: {
                        ps.setNull(i, 12);
                    }
                }
            }
            return;
        }
        this.setNonNullParameter(ps, i, parameter, jdbcType);
    }

    private void writeUuid(PreparedStatement ps, int i, UUID uuid, JdbcType jdbcType) throws SQLException {
        Objects.requireNonNull(uuid, "uuid must not be null");
        if (jdbcType == JdbcType.BINARY) {
            ps.setBytes(i, TypedUUIDHandler.uuidToBytes(uuid));
        } else {
            ps.setString(i, uuid.toString());
        }
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.readUuid(rs.getObject(columnName));
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.readUuid(rs.getObject(columnIndex));
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.readUuid(cs.getObject(columnIndex));
    }

    private Object readUuid(Object dbVal) throws SQLException {
        if (dbVal == null) {
            return null;
        }
        if (dbVal instanceof UUID) {
            return dbVal;
        }
        if (dbVal instanceof byte[]) {
            byte[] bytes = (byte[])dbVal;
            if (bytes.length != 16) {
                throw new SQLException("UUID binary must be 16 bytes, actual=" + bytes.length);
            }
            return TypedUUIDHandler.bytesToUuid(bytes);
        }
        return TypedUUIDHandler.parseUuidLenient(dbVal.toString());
    }
}

