/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.core.typehandler;

import io.r2mo.typed.json.JArray;
import io.r2mo.typed.json.JBase;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={JArray.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.LONGVARCHAR, JdbcType.CLOB})
public class TypedJArrayHandler
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        String jsonString;
        if (parameter == null) {
            ps.setString(i, null);
            return;
        }
        if (parameter instanceof JArray) {
            JArray parameterA = (JArray)parameter;
            jsonString = parameterA.encode();
        } else {
            String parameterS;
            jsonString = parameter instanceof String ? (parameterS = (String)parameter) : parameter.toString();
        }
        ps.setString(i, jsonString);
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String jsonString = rs.getString(columnName);
        return this.parseJArray(jsonString);
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String jsonString = rs.getString(columnIndex);
        return this.parseJArray(jsonString);
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String jsonString = cs.getString(columnIndex);
        return this.parseJArray(jsonString);
    }

    private JArray parseJArray(String jsonString) {
        return (JArray)JBase.parse((String)jsonString);
    }
}

