/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.r2mo.dbe.mybatisplus.generator.GenConfig;
import io.r2mo.dbe.mybatisplus.generator.GenProcessor;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenProcessorSql
implements GenProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenProcessorSql.class);
    private static final List<String> FIELD_ORDER = List.of("id", "code", "name", "type", "status", "enabled", "description", "parentId", "appId", "directoryId", "createdAt", "createdBy", "updatedAt", "updatedBy", "language", "version", "cMetadata");

    GenProcessorSql() {
    }

    private static int getFieldPriority(String fieldName) {
        int index = FIELD_ORDER.indexOf(fieldName);
        return index == -1 ? Integer.MAX_VALUE : index;
    }

    private static String generate(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        String tableName = GenProcessorSql.getTableName(entityClass);
        List<FieldInfo> allFields = GenProcessorSql.collectAllFields(entityClass);
        sql.append("CREATE TABLE ").append(tableName).append(" (\n");
        ArrayList<Object> columnDefinitions = new ArrayList<Object>();
        String primaryKeyDefinition = null;
        for (FieldInfo fieldInfo : allFields) {
            String columnDefinition = GenProcessorSql.generateColumnDefinition(fieldInfo);
            if (fieldInfo.isPrimaryKey) {
                columnDefinitions.add(fieldInfo.columnName + " VARCHAR(36) PRIMARY KEY");
                primaryKeyDefinition = "PRIMARY KEY (" + fieldInfo.columnName + ")";
                continue;
            }
            columnDefinitions.add(columnDefinition);
        }
        for (int i = 0; i < columnDefinitions.size(); ++i) {
            sql.append("    ").append((String)columnDefinitions.get(i));
            if (i < columnDefinitions.size() - 1 || primaryKeyDefinition != null) {
                sql.append(",");
            }
            sql.append("\n");
        }
        if (primaryKeyDefinition != null) {
            sql.append("    ").append(primaryKeyDefinition).append("\n");
        }
        sql.append(");");
        return sql.toString();
    }

    private static List<FieldInfo> collectAllFields(Class<?> clazz) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        HashSet<String> processedFields = new HashSet<String>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                TableField annotation;
                if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(JsonIgnore.class) || Objects.nonNull(annotation = field.getAnnotation(TableField.class)) && !annotation.exist() || processedFields.contains(field.getName())) continue;
                fields.add(new FieldInfo(field));
                processedFields.add(field.getName());
            }
        }
        return fields.stream().sorted((f1, f2) -> {
            int priority2;
            int priority1 = GenProcessorSql.getFieldPriority(f1.fieldName);
            if (priority1 != (priority2 = GenProcessorSql.getFieldPriority(f2.fieldName))) {
                return Integer.compare(priority1, priority2);
            }
            return f1.fieldName.compareTo(f2.fieldName);
        }).collect(Collectors.toList());
    }

    private static String generateColumnDefinition(FieldInfo fieldInfo) {
        StringBuilder definition = new StringBuilder();
        definition.append(fieldInfo.columnName).append(" ").append(fieldInfo.columnType);
        if (!fieldInfo.nullable) {
            definition.append(" NOT NULL");
        }
        if (fieldInfo.defaultValue != null) {
            definition.append(" DEFAULT ").append(fieldInfo.defaultValue);
        }
        if (fieldInfo.comment != null && !fieldInfo.comment.isEmpty()) {
            definition.append(" COMMENT '").append(fieldInfo.comment).append("'");
        }
        return definition.toString();
    }

    private static String getTableName(Class<?> entityClass) {
        TableName tableNameAnnotation = entityClass.getAnnotation(TableName.class);
        if (tableNameAnnotation != null && !tableNameAnnotation.value().isEmpty()) {
            return tableNameAnnotation.value();
        }
        return GenProcessorSql.camelToUnderline(entityClass.getSimpleName());
    }

    private static String getColumnName(Field field) {
        TableId tableIdAnnotation = field.getAnnotation(TableId.class);
        if (tableIdAnnotation != null && !tableIdAnnotation.value().isEmpty()) {
            return tableIdAnnotation.value();
        }
        TableField tableFieldAnnotation = field.getAnnotation(TableField.class);
        if (tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty()) {
            return tableFieldAnnotation.value();
        }
        return GenProcessorSql.camelToUnderline(field.getName());
    }

    private static String getColumnType(Field field) {
        Class<?> type = field.getType();
        TableField tableFieldAnnotation = field.getAnnotation(TableField.class);
        if (tableFieldAnnotation != null) {
            // empty if block
        }
        if (type == String.class) {
            return "VARCHAR(255)";
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return "INT";
        }
        if (type == Long.class || type == Long.TYPE) {
            return "BIGINT";
        }
        if (type == Double.class || type == Double.TYPE) {
            return "DOUBLE";
        }
        if (type == Float.class || type == Float.TYPE) {
            return "FLOAT";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "TINYINT(1)";
        }
        if (type == Date.class) {
            return "DATETIME";
        }
        if (type == LocalDateTime.class) {
            return "DATETIME";
        }
        if (type == LocalDate.class) {
            return "DATE";
        }
        if (type == BigDecimal.class) {
            return "DECIMAL(10,2)";
        }
        return "VARCHAR(255)";
    }

    private static boolean isPrimaryKey(Field field) {
        return field.isAnnotationPresent(TableId.class);
    }

    private static boolean isNullable(Field field) {
        TableField tableFieldAnnotation = field.getAnnotation(TableField.class);
        if (tableFieldAnnotation != null && !tableFieldAnnotation.exist()) {
            return true;
        }
        return !GenProcessorSql.isPrimaryKey(field);
    }

    private static String getDefaultValue(Field field) {
        return null;
    }

    private static String getComment(Field field) {
        Schema schema = field.getDeclaredAnnotation(Schema.class);
        return Objects.nonNull(schema) ? schema.description() : null;
    }

    private static String camelToUnderline(String camelCase) {
        if (camelCase == null || camelCase.isEmpty()) {
            return camelCase;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    result.append("_");
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public void generate(Class<?> entity, GenConfig config) {
        String sqlContent = GenProcessorSql.generate(entity);
        Path database = config.outSql();
        Path dbSchema = database.resolve("schema");
        TableName table = entity.getAnnotation(TableName.class);
        if (Objects.isNull(table)) {
            log.warn("[ GEN ] Entity {} does not have @TableName annotation, skipping SQL generation.", (Object)entity.getSimpleName());
            return;
        }
        String filename = "V1_" + table.value() + ".sql";
        Path sqlFilePath = dbSchema.resolve(filename);
        try {
            Files.createDirectories(dbSchema, new FileAttribute[0]);
            Files.writeString(sqlFilePath, (CharSequence)sqlContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            log.info("[GEN] Generated SQL File: {}", (Object)sqlFilePath);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class FieldInfo {
        String fieldName;
        String columnName;
        String columnType;
        boolean isPrimaryKey;
        boolean nullable;
        String defaultValue;
        String comment;

        FieldInfo(Field field) {
            this.fieldName = field.getName();
            this.columnName = GenProcessorSql.getColumnName(field);
            this.columnType = GenProcessorSql.getColumnType(field);
            this.isPrimaryKey = GenProcessorSql.isPrimaryKey(field);
            this.nullable = GenProcessorSql.isNullable(field);
            this.defaultValue = GenProcessorSql.getDefaultValue(field);
            this.comment = GenProcessorSql.getComment(field);
        }
    }
}

