/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.r2mo.dbe.mybatisplus.generator.AbstractGenProcessor;
import io.r2mo.dbe.mybatisplus.generator.GenConfig;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenProcessorMapperXml
extends AbstractGenProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenProcessorMapperXml.class);

    GenProcessorMapperXml() {
    }

    @Override
    public void generate(Class<?> entity, GenConfig config) {
        try {
            Configuration cfg = this.getConfigurationFromDependency();
            Map<String, Object> dataModel = this.getDataParameters(entity);
            Template mapperTemplate = cfg.getTemplate("mapper-xml.ftl");
            String mapperXml = this.getClassName(entity) + "Mapper";
            Path packagePath = config.outProviderXml();
            if (!Files.exists(packagePath, new LinkOption[0])) {
                Files.createDirectories(packagePath, new FileAttribute[0]);
                log.info("[ GEN ] Directory created: " + String.valueOf(packagePath));
            }
            Path mapperInterfacePath = packagePath.resolve(mapperXml + ".xml");
            try (BufferedWriter writer = Files.newBufferedWriter(mapperInterfacePath, new OpenOption[0]);){
                mapperTemplate.process(dataModel, (Writer)writer);
                log.info("[ GEN ] Mapper: " + String.valueOf(mapperInterfacePath) + " generated successfully.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

