/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.TableName;
import io.r2mo.dbe.mybatisplus.generator.GenConfig;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenConfig
implements GenConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGenConfig.class);
    private final transient Package basePackage = this.getClass().getPackage();

    protected AbstractGenConfig() {
    }

    @Override
    public Package getBasePackage() {
        return this.basePackage;
    }

    @Override
    public Path outProvider() {
        Path path = this.output("-provider");
        return path.resolve("src/main/java");
    }

    @Override
    public Path outProviderXml() {
        Path path = this.output("-provider");
        String module = Path.of(System.getProperty("user.dir"), new String[0]).toFile().getName();
        return path.resolve("src/main/resources/" + module + "/mapper");
    }

    @Override
    public Path outSql() {
        Path path = this.output("-domain");
        String module = Path.of(System.getProperty("user.dir"), new String[0]).toFile().getName();
        return path.resolve("src/main/resources/" + module + "/database");
    }

    @Override
    public List<Class<?>> getEntities() {
        String entityPackageName = this.basePackage.getName() + ".domain";
        log.info("[ GEN ] Entity package name: {}", (Object)entityPackageName);
        Reflections reflections = new Reflections(entityPackageName, new Scanner[0]);
        return reflections.getTypesAnnotatedWith(TableName.class).stream().toList();
    }

    private Path output(String suffix) {
        Path path = Path.of(System.getProperty("user.dir"), new String[0]);
        String module = path.toFile().getName();
        String submodule = module + suffix;
        return path.resolve(submodule);
    }

    @Override
    public Path outApi() {
        Path path = this.output("-api");
        return path.resolve("src/main/java");
    }
}

