/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.dbe.mybatisplus.core.typehandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={UUID.class})
public class TypedUUIDHandler
extends BaseTypeHandler<UUID> {
    public void setParameter(PreparedStatement ps, int i, UUID parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null && jdbcType == JdbcType.OTHER) {
            ps.setString(i, UUID.randomUUID().toString());
        } else if (Objects.nonNull(parameter)) {
            ps.setString(i, parameter.toString());
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, UUID parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter.toString());
    }

    public UUID getNullableResult(ResultSet resultSet, String columnName) throws SQLException {
        return this.getResult(resultSet.getString(columnName));
    }

    public UUID getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return this.getResult(resultSet.getString(i));
    }

    public UUID getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return this.getResult(callableStatement.getString(i));
    }

    private UUID getResult(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return UUID.fromString(value);
    }
}

