/*
 * Decompiled with CFR 0.152.
 */
package io.r2mo.boot.spring;

import cn.hutool.extra.spring.SpringUtil;
import com.github.yulichang.base.MPJBaseMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.core.ResolvableType;

final class RADMapper {
    private static final Map<Class<?>, Class<? extends MPJBaseMapper<?>>> CACHE = new ConcurrentHashMap();

    private RADMapper() {
    }

    static <T> MPJBaseMapper<T> findMapper(Class<T> entityClass) {
        Map factories = SpringUtil.getBeansOfType(SqlSessionFactory.class);
        if (factories == null || factories.isEmpty()) {
            throw new IllegalStateException("[R2MO] \u5bb9\u5668\u4e2d\u672a\u53d1\u73b0 SqlSessionFactory\uff0c\u65e0\u6cd5\u5b9a\u4f4d MPJBaseMapper\u3002");
        }
        return RADMapper.findMapper(entityClass, factories.values());
    }

    static <T> MPJBaseMapper<T> findMapper(Class<T> entityClass, SqlSessionFactory factory) {
        Objects.requireNonNull(factory, "[R2MO] \u4f20\u5165\u7684 SqlSessionFactory \u4e0d\u80fd\u4e3a null");
        return RADMapper.findMapper(entityClass, Collections.singleton(factory));
    }

    private static <T> MPJBaseMapper<T> findMapper(Class<T> entityClass, Collection<SqlSessionFactory> factories) {
        Class<? extends MPJBaseMapper<?>> cached = CACHE.get(entityClass);
        if (cached != null) {
            return (MPJBaseMapper)SpringUtil.getBean(cached);
        }
        for (SqlSessionFactory factory : factories) {
            Configuration cfg = factory.getConfiguration();
            Collection mappers = cfg.getMapperRegistry().getMappers();
            for (Class mapperInterface : mappers) {
                Class generic;
                ResolvableType rt = ResolvableType.forClass((Class)mapperInterface).as(MPJBaseMapper.class);
                if (!rt.hasGenerics() || (generic = rt.getGeneric(new int[]{0}).resolve()) == null || !generic.equals(entityClass)) continue;
                MPJBaseMapper bean = (MPJBaseMapper)SpringUtil.getBean((Class)mapperInterface);
                CACHE.put(entityClass, mapperInterface);
                return bean;
            }
        }
        throw new IllegalStateException("[R2MO] \u672a\u627e\u5230\u5b9e\u4f53 " + entityClass.getName() + " \u5bf9\u5e94\u7684 MPJBaseMapper\uff0c\u8bf7\u786e\u8ba4\uff1a\n1) Mapper \u63a5\u53e3\u5df2 extends com.github.yulichang.base.MPJBaseMapper<" + entityClass.getSimpleName() + ">\n2) Mapper \u63a5\u53e3\u5904\u4e8e @MapperScan \u626b\u63cf\u8303\u56f4\u5185\u5e76\u6210\u529f\u6ce8\u518c\n3) \u5f53\u524d\u6240\u7528 SqlSessionFactory \u4e0e\u8be5 Mapper \u4f4d\u4e8e\u540c\u4e00\u6570\u636e\u6e90\u914d\u7f6e\u4e2d");
    }
}

