/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.backbone.johnzon;

import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.util.function.Function;
import org.apache.johnzon.jsonb.api.experimental.JsonbExtension;

public class Object2JsonSerializer
implements Function<Object, JsonValue> {
    private final Function<Object, JsonValue> delegate;

    public Object2JsonSerializer(Jsonb jsonb) {
        Function<Object, JsonValue> delegate;
        try {
            delegate = Thread.currentThread().getContextClassLoader().loadClass("org.apache.johnzon.jsonb.api.experimental.JsonbExtension").isInstance(jsonb) ? new JohnzonImpl(jsonb) : new PortableImpl(jsonb);
        }
        catch (ClassNotFoundException e) {
            delegate = new PortableImpl(jsonb);
        }
        this.delegate = delegate;
    }

    @Override
    public JsonValue apply(Object o) {
        return this.delegate.apply(o);
    }

    private static class PortableImpl
    implements Function<Object, JsonValue> {
        private final Jsonb impl;

        private PortableImpl(Jsonb jsonb) {
            this.impl = jsonb;
        }

        @Override
        public JsonValue apply(Object o) {
            return this.impl.fromJson(this.impl.toJson(o), JsonValue.class);
        }
    }

    private static class JohnzonImpl
    implements Function<Object, JsonValue> {
        private final JsonbExtension impl;

        private JohnzonImpl(Jsonb jsonb) {
            this.impl = (JsonbExtension)JsonbExtension.class.cast(jsonb);
        }

        @Override
        public JsonValue apply(Object o) {
            return this.impl.toJsonValue(o);
        }
    }
}

