/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import jakarta.enterprise.inject.Vetoed;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.hash.XxHash64;
import org.apache.webbeans.proxy.Unsafe;
import org.apache.webbeans.spi.DefiningClassService;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.MethodVisitor;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.shade.commons.EmptyVisitor;

public abstract class AbstractProxyFactory {
    public static final int MAX_CLASSLOAD_TRIES = 10000;
    public static final int MODIFIER_VARARGS = 128;
    protected final Unsafe unsafe;
    private final DefiningClassService definingService;
    private final boolean useStaticNames;
    private final boolean useXXhash64;
    protected WebBeansContext webBeansContext;
    private final int javaVersion;
    public static final String FIELD_BEAN_PASSIVATION_ID = "owbBeanPassivationId";

    protected AbstractProxyFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.javaVersion = this.determineDefaultJavaVersion();
        this.definingService = webBeansContext.getService(DefiningClassService.class);
        this.useStaticNames = Boolean.parseBoolean(webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.proxy.useStaticNames"));
        this.useXXhash64 = Boolean.parseBoolean(webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.proxy.staticNames.useXxHash64"));
        this.unsafe = this.definingService == null ? new Unsafe() : null;
    }

    private int determineDefaultJavaVersion() {
        String javaVersionProp = this.webBeansContext.getOpenWebBeansConfiguration().getGeneratorJavaVersion();
        if (javaVersionProp == null) {
            javaVersionProp = System.getProperty("java.version");
        }
        if (javaVersionProp != null) {
            if (javaVersionProp.startsWith("1.8")) {
                return 52;
            }
            if (javaVersionProp.startsWith("9") || javaVersionProp.startsWith("1.9")) {
                return 53;
            }
            if (javaVersionProp.startsWith("10")) {
                return 54;
            }
            if (javaVersionProp.startsWith("11")) {
                return 55;
            }
            if (javaVersionProp.startsWith("12")) {
                return 56;
            }
            if (javaVersionProp.startsWith("13")) {
                return 57;
            }
            try {
                int i = Integer.parseInt(javaVersionProp);
                if (i > 13) {
                    return 57 + (i - 13);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 52;
    }

    protected ClassLoader getProxyClassLoader(Class<?> beanClass) {
        if (this.definingService != null) {
            return this.definingService.getProxyClassLoader(beanClass);
        }
        return this.webBeansContext.getApplicationBoundaryService().getBoundaryClassLoader(beanClass);
    }

    protected abstract Class<?> getMarkerInterface();

    protected abstract void createInstanceVariables(ClassWriter var1, Class<?> var2, String var3);

    protected abstract void createSerialisation(ClassWriter var1, String var2, Class<?> var3, String var4);

    protected abstract void createConstructor(ClassWriter var1, String var2, Class<?> var3, String var4, Constructor<?> var5) throws ProxyGenerationException;

    protected abstract void delegateInterceptedMethods(ClassLoader var1, ClassWriter var2, String var3, Class<?> var4, Method[] var5) throws ProxyGenerationException;

    protected abstract void delegateNonInterceptedMethods(ClassLoader var1, ClassWriter var2, String var3, Class<?> var4, Method[] var5) throws ProxyGenerationException;

    @Deprecated
    protected String getUnusedProxyClassName(ClassLoader classLoader, String proxyClassName) {
        String finalName = proxyClassName = this.fixPreservedPackages(proxyClassName);
        if (this.useStaticNames) {
            return proxyClassName + 0;
        }
        for (int i = 0; i < 10000; ++i) {
            try {
                finalName = proxyClassName + i;
                Class.forName(finalName, true, classLoader);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                return finalName;
            }
        }
        throw new WebBeansException("Unable to detect a free proxy class name based on: " + proxyClassName);
    }

    protected String getUnusedProxyClassName(ClassLoader classLoader, String proxyClassName, Method[] proxiedMethods, Method[] notProxiedMethods) {
        proxyClassName = this.fixPreservedPackages(proxyClassName);
        if (this.useStaticNames) {
            return proxyClassName + this.uniqueHash(proxiedMethods, notProxiedMethods);
        }
        return this.getUnusedProxyClassName(classLoader, proxyClassName);
    }

    protected String uniqueHash(Method[] proxiedMethods, Method[] notProxiedMethods) {
        if (this.useXXhash64) {
            return Long.toString(Math.abs(XxHash64.apply(Stream.concat(proxiedMethods == null ? Stream.empty() : Stream.of(proxiedMethods).map(Method::toGenericString).sorted(), notProxiedMethods == null ? Stream.empty() : Stream.of(notProxiedMethods).filter(it -> it.getDeclaringClass() != Object.class).map(Method::toGenericString).map(it -> "<NOT>" + it).sorted()).collect(Collectors.joining("_")))));
        }
        return "0";
    }

    protected <T> String getSignedClassProxyName(Class<T> classToProxy) {
        return "org.apache.webbeans.custom.signed." + classToProxy.getSimpleName() + Math.abs(classToProxy.hashCode());
    }

    protected String fixPreservedPackages(String proxyClassName) {
        return this.webBeansContext.getOpenWebBeansConfiguration().getProxyReservedPackages().stream().filter(proxyClassName::startsWith).findFirst().map(it -> this.fixPreservedPackage(proxyClassName, (String)it)).orElse(proxyClassName);
    }

    private String fixPreservedPackage(String className, String forbiddenPackagePrefix) {
        String fixedClassName = className;
        if (className.startsWith(forbiddenPackagePrefix)) {
            fixedClassName = "org.apache.webbeans.custom." + className.substring(className.lastIndexOf(46) + 1) + Math.abs(className.hashCode());
        }
        return fixedClassName;
    }

    protected <T> Class<T> createProxyClass(ClassLoader classLoader, String proxyClassName, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods) throws ProxyGenerationException {
        return this.createProxyClass(classLoader, proxyClassName, classToProxy, interceptedMethods, nonInterceptedMethods, null);
    }

    protected <T> Class<T> createProxyClass(ClassLoader classLoader, String proxyClassName, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods, Constructor<T> constructor) throws ProxyGenerationException {
        String proxyClassFileName = proxyClassName.replace('.', '/');
        byte[] proxyBytes = this.generateProxy(classLoader, classToProxy, proxyClassName, proxyClassFileName, this.sortOutDuplicateMethods(interceptedMethods), this.sortOutDuplicateMethods(nonInterceptedMethods), constructor);
        if (this.definingService != null) {
            return this.definingService.defineAndLoad(proxyClassName, proxyBytes, classToProxy);
        }
        return this.unsafe.defineAndLoadClass(classLoader, proxyClassName, proxyBytes, classToProxy);
    }

    protected <T> T newInstance(Class<? extends T> proxyClass) {
        if (this.unsafe != null) {
            return this.unsafe.unsafeNewInstance(proxyClass);
        }
        try {
            return proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + proxyClass.getName(), e);
        }
    }

    private Method[] sortOutDuplicateMethods(Method[] methods) {
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<Method> duplicates = new ArrayList<Method>();
        for (Method outer : methods) {
            for (Method inner : methods) {
                if (inner == outer || !this.hasSameSignature(outer, inner) || duplicates.contains(outer) || duplicates.contains(inner)) continue;
                duplicates.add(inner);
            }
        }
        ArrayList<Method> outsorted = new ArrayList<Method>(Arrays.asList(methods));
        outsorted.removeAll(duplicates);
        return outsorted.toArray(new Method[outsorted.size()]);
    }

    private boolean hasSameSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }

    private byte[] generateProxy(ClassLoader classLoader, Class<?> classToProxy, String proxyClassName, String proxyClassFileName, Method[] interceptedMethods, Method[] nonInterceptedMethods, Constructor<?> constructor) throws ProxyGenerationException {
        ClassWriter cw = new ClassWriter(2);
        String classFileName = classToProxy.getName().replace('.', '/');
        String[] interfaceNames = new String[]{Type.getInternalName(this.getMarkerInterface())};
        String superClassName = classFileName;
        if (classToProxy.isInterface()) {
            interfaceNames = new String[]{Type.getInternalName(classToProxy), interfaceNames[0]};
            superClassName = Type.getInternalName(Object.class);
        }
        cw.visit(this.findJavaVersion(classToProxy), 4129, proxyClassFileName, null, superClassName, interfaceNames);
        cw.visitSource(classFileName + ".java", null);
        cw.visitAnnotation(Type.getDescriptor(Vetoed.class), true).visitEnd();
        this.createInstanceVariables(cw, classToProxy, classFileName);
        this.createSerialisation(cw, proxyClassFileName, classToProxy, classFileName);
        cw.visitField(10, FIELD_BEAN_PASSIVATION_ID, Type.getDescriptor(String.class), null, null).visitEnd();
        this.createConstructor(cw, proxyClassFileName, classToProxy, classFileName, constructor);
        if (nonInterceptedMethods != null) {
            this.delegateNonInterceptedMethods(classLoader, cw, proxyClassFileName, classToProxy, nonInterceptedMethods);
        }
        if (interceptedMethods != null) {
            this.delegateInterceptedMethods(classLoader, cw, proxyClassFileName, classToProxy, interceptedMethods);
        }
        return cw.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findJavaVersion(Class<?> from) {
        String resource = from.getName().replace('.', '/') + ".class";
        try (InputStream stream = from.getClassLoader().getResourceAsStream(resource);){
            if (stream == null) {
                int n = this.javaVersion;
                return n;
            }
            ClassReader reader = new ClassReader(stream);
            VersionVisitor visitor = new VersionVisitor();
            reader.accept(visitor, 7);
            if (visitor.version == 0) return this.javaVersion;
            int n = visitor.version;
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.javaVersion;
    }

    protected boolean unproxyableMethod(Method delegatedMethod) {
        int modifiers = delegatedMethod.getModifiers();
        return (modifiers & 0x11A) > 0 || "finalize".equals(delegatedMethod.getName()) || delegatedMethod.isBridge();
    }

    protected String getWrapperType(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return Integer.class.getCanonicalName().replace('.', '/');
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class.getCanonicalName().replace('.', '/');
        }
        if (Character.TYPE.equals(type)) {
            return Character.class.getCanonicalName().replace('.', '/');
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class.getCanonicalName().replace('.', '/');
        }
        if (Short.TYPE.equals(type)) {
            return Short.class.getCanonicalName().replace('.', '/');
        }
        if (Float.TYPE.equals(type)) {
            return Float.class.getCanonicalName().replace('.', '/');
        }
        if (Long.TYPE.equals(type)) {
            return Long.class.getCanonicalName().replace('.', '/');
        }
        if (Double.TYPE.equals(type)) {
            return Double.class.getCanonicalName().replace('.', '/');
        }
        if (Void.TYPE.equals(type)) {
            return Void.class.getCanonicalName().replace('.', '/');
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected int getVarInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 21;
            }
            if (Boolean.TYPE.equals(type)) {
                return 21;
            }
            if (Character.TYPE.equals(type)) {
                return 21;
            }
            if (Byte.TYPE.equals(type)) {
                return 21;
            }
            if (Short.TYPE.equals(type)) {
                return 21;
            }
            if (Float.TYPE.equals(type)) {
                return 23;
            }
            if (Long.TYPE.equals(type)) {
                return 22;
            }
            if (Double.TYPE.equals(type)) {
                return 24;
            }
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected void pushIntOntoStack(MethodVisitor mv, int i) {
        if (i == 0) {
            mv.visitInsn(3);
        } else if (i == 1) {
            mv.visitInsn(4);
        } else if (i == 2) {
            mv.visitInsn(5);
        } else if (i == 3) {
            mv.visitInsn(6);
        } else if (i == 4) {
            mv.visitInsn(7);
        } else if (i == 5) {
            mv.visitInsn(8);
        } else if (i > 5 && i <= 255) {
            mv.visitIntInsn(16, i);
        } else {
            mv.visitIntInsn(17, i);
        }
    }

    protected int getReturnInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Void.TYPE.equals(type)) {
                return 177;
            }
            if (Integer.TYPE.equals(type)) {
                return 172;
            }
            if (Boolean.TYPE.equals(type)) {
                return 172;
            }
            if (Character.TYPE.equals(type)) {
                return 172;
            }
            if (Byte.TYPE.equals(type)) {
                return 172;
            }
            if (Short.TYPE.equals(type)) {
                return 172;
            }
            if (Float.TYPE.equals(type)) {
                return 174;
            }
            if (Long.TYPE.equals(type)) {
                return 173;
            }
            if (Double.TYPE.equals(type)) {
                return 175;
            }
        }
        return 176;
    }

    protected String getCastType(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return this.getWrapperType(returnType);
        }
        return Type.getInternalName(returnType);
    }

    protected String getPrimitiveMethod(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "intValue";
        }
        if (Boolean.TYPE.equals(type)) {
            return "booleanValue";
        }
        if (Character.TYPE.equals(type)) {
            return "charValue";
        }
        if (Byte.TYPE.equals(type)) {
            return "byteValue";
        }
        if (Short.TYPE.equals(type)) {
            return "shortValue";
        }
        if (Float.TYPE.equals(type)) {
            return "floatValue";
        }
        if (Long.TYPE.equals(type)) {
            return "longValue";
        }
        if (Double.TYPE.equals(type)) {
            return "doubleValue";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected void generateReturn(MethodVisitor mv, Method delegatedMethod) {
        Class<?> returnType = delegatedMethod.getReturnType();
        mv.visitInsn(this.getReturnInsn(returnType));
    }

    protected void pushMethodParameterArray(MethodVisitor mv, Class<?>[] parameterTypes) {
        this.createArrayDefinition(mv, parameterTypes.length, Object.class);
        int index = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitVarInsn(this.getVarInsn(parameterType), index);
                mv.visitMethodInsn(184, wrapperType, "valueOf", "(" + Type.getDescriptor(parameterType) + ")L" + wrapperType + ";", false);
                mv.visitInsn(83);
                if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                    index += 2;
                    continue;
                }
                ++index;
                continue;
            }
            mv.visitVarInsn(25, index);
            mv.visitInsn(83);
            ++index;
        }
    }

    protected void createArrayDefinition(MethodVisitor mv, int size, Class<?> type) throws ProxyGenerationException {
        if (size < 0) {
            throw new ProxyGenerationException("Array size cannot be less than zero");
        }
        this.pushIntOntoStack(mv, size);
        mv.visitTypeInsn(189, type.getCanonicalName().replace('.', '/'));
    }

    private static class VersionVisitor
    extends EmptyVisitor {
        private int version;

        private VersionVisitor() {
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.version = version;
        }
    }
}

