/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.third.ThirdpartyBeanImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

public class InjectionPointProducer
extends AbstractProducer<InjectionPoint> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InjectionPoint produce(Map<Interceptor<?>, ?> interceptors, CreationalContextImpl<InjectionPoint> creationalContextImpl) {
        InjectionPoint injectionPoint;
        if (creationalContextImpl == null) {
            return null;
        }
        InjectionPoint first = creationalContextImpl.removeInjectionPoint();
        if (!InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(first.getType()))) {
            if (!ThirdpartyBeanImpl.class.isInstance(creationalContextImpl.getBean()) && !InjectionPointBean.class.isInstance(creationalContextImpl.getBean())) {
                throw new IllegalStateException("Inconsistent injection point stack");
            }
            injectionPoint = first;
        } else {
            injectionPoint = creationalContextImpl.getInjectionPoint();
        }
        if (injectionPoint == null) {
            return null;
        }
        try {
            ParameterizedType parameterizedType;
            Type type = injectionPoint.getType();
            if (ParameterizedType.class.isInstance(type) && (parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type)).getRawType() == Instance.class) {
                Bean<InjectionPoint> bean = creationalContextImpl.getBean();
                InjectionPointDelegate injectionPointDelegate = new InjectionPointDelegate(injectionPoint, bean.getBeanClass() != null ? bean.getBeanClass() : parameterizedType.getActualTypeArguments()[0]);
                return injectionPointDelegate;
            }
            InjectionPoint injectionPoint2 = injectionPoint;
            return injectionPoint2;
        }
        finally {
            creationalContextImpl.putInjectionPoint(first);
        }
    }

    @Override
    public void dispose(InjectionPoint ip) {
    }

    private static class InjectionPointDelegate
    implements InjectionPoint,
    Serializable {
        private InjectionPoint ip;
        private Type type;

        public InjectionPointDelegate(InjectionPoint injectionPoint, Type type) {
            this.ip = injectionPoint;
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.ip.getQualifiers();
        }

        @Override
        public Bean<?> getBean() {
            return this.ip.getBean();
        }

        @Override
        public Member getMember() {
            return this.ip.getMember();
        }

        @Override
        public Annotated getAnnotated() {
            return this.ip.getAnnotated();
        }

        @Override
        public boolean isDelegate() {
            return this.ip.isDelegate();
        }

        @Override
        public boolean isTransient() {
            return this.ip.isTransient();
        }

        private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
            OwbCustomObjectInputStream owbCustomObjectInputStream = new OwbCustomObjectInputStream(inp, WebBeansUtil.getCurrentClassLoader());
            this.type = (Type)Type.class.cast(owbCustomObjectInputStream.readObject());
            this.ip = (InjectionPoint)InjectionPoint.class.cast(owbCustomObjectInputStream.readObject());
        }

        private void writeObject(ObjectOutputStream op) throws IOException {
            ObjectOutputStream out = new ObjectOutputStream(op);
            out.writeObject(this.type);
            out.writeObject(this.ip);
        }
    }
}

