/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import jakarta.enterprise.context.BusyConversationException;
import jakarta.enterprise.context.ContextException;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.NonexistentConversationException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.annotation.BeforeDestroyedLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationStorageBean;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.util.Asserts;

public class ConversationManager {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ConversationManager.class);
    private final WebBeansContext webBeansContext;
    private final Bean<Set<ConversationContext>> conversationStorageBean;

    public ConversationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        ConversationStorageBean convBean = new ConversationStorageBean(webBeansContext);
        BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
        bm.addInternalBean(convBean);
        this.conversationStorageBean = bm.resolve(bm.getBeans("apache.openwebbeans.OwbInternalConversationStorageBean"));
    }

    public ConversationContext getConversationContext(Context sessionContext) {
        ConversationService conversationService = this.webBeansContext.getConversationService();
        Set<ConversationContext> conversationContexts = this.getSessionConversations(sessionContext, false);
        ContextException problem = null;
        String conversationId = conversationService.getConversationId();
        if (conversationId != null && conversationId.length() > 0) {
            if (conversationContexts != null) {
                for (ConversationContext conversationContext : conversationContexts) {
                    if (!conversationId.equals(conversationContext.getConversation().getId())) continue;
                    if (conversationContext.getConversation().iUseIt() > 1) {
                        problem = new BusyConversationException("Propogated conversation with cid=" + conversationContext.getConversation().getId() + " is used by other request. It creates a new transient conversation");
                        conversationContext.getConversation().setProblemDuringCreation(problem);
                    } else {
                        conversationContext.getConversation().updateLastAccessTime();
                    }
                    conversationContext.setActive(true);
                    return conversationContext;
                }
            }
            problem = new NonexistentConversationException("Propogated conversation with cid=" + conversationId + " cannot be restored. Will create a new transient conversation.");
        }
        ConversationContext conversationContext = new ConversationContext(this.webBeansContext);
        conversationContext.setActive(true);
        conversationContext.getConversation().setProblemDuringCreation(problem);
        return conversationContext;
    }

    public void addToConversationStorage(ConversationContext conversationContext, String conversationId) {
        Asserts.assertNotNull(conversationId, "conversationId");
        Context sessionContext = this.webBeansContext.getContextsService().getCurrentContext(SessionScoped.class, true);
        Set<ConversationContext> sessionConversations = this.getSessionConversations(sessionContext, true);
        for (ConversationContext sessionConversation : sessionConversations) {
            if (!conversationId.equals(sessionConversation.getConversation().getId())) continue;
            throw new IllegalArgumentException("Conversation with id=" + conversationId + " already exists!");
        }
        sessionConversations.add(conversationContext);
    }

    public boolean removeConversationFromStorage(ConversationContext conversationContext) {
        Context sessionContext = this.webBeansContext.getContextsService().getCurrentContext(SessionScoped.class);
        if (sessionContext != null) {
            Set<ConversationContext> sessionConversations = this.getSessionConversations(sessionContext, true);
            return sessionConversations.remove(conversationContext);
        }
        return false;
    }

    public Conversation getConversationBeanReference() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        Bean<?> bean = beanManager.getBeans((Type)((Object)Conversation.class), DefaultLiteral.INSTANCE).iterator().next();
        Conversation conversation = (Conversation)beanManager.getReference(bean, (Type)((Object)Conversation.class), beanManager.createCreationalContext(bean));
        return conversation;
    }

    public boolean conversationTimedOut(ConversationImpl conv) {
        long timeout = 0L;
        try {
            timeout = conv.getTimeout();
        }
        catch (BusyConversationException bce) {
            return false;
        }
        if (timeout != 0L && System.currentTimeMillis() - conv.getLastAccessTime() > timeout) {
            logger.log(Level.FINE, "INFO_0011", conv.getId());
            return true;
        }
        return false;
    }

    public void destroyConversationContext(ConversationContext ctx) {
        this.webBeansContext.getBeanManagerImpl().fireEvent(this.getLifecycleEventPayload(ctx), BeforeDestroyedLiteral.INSTANCE_CONVERSATION_SCOPED);
        ctx.destroy();
        this.webBeansContext.getBeanManagerImpl().fireEvent(this.getLifecycleEventPayload(ctx), DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED);
    }

    public Object getLifecycleEventPayload(ConversationContext ctx) {
        RequestContext requestContext;
        Object payLoad = null;
        if (ctx.getConversation().getId() != null) {
            payLoad = ctx.getConversation().getId();
        }
        if (payLoad == null && (requestContext = (RequestContext)this.webBeansContext.getContextsService().getCurrentContext(RequestScoped.class, false)) != null) {
            payLoad = requestContext.getRequestObject();
        }
        if (payLoad == null) {
            payLoad = new Object();
        }
        return payLoad;
    }

    public Set<ConversationContext> getSessionConversations(Context sessionContext, boolean create) {
        Set<ConversationContext> conversationContexts = null;
        if (sessionContext != null) {
            if (!create) {
                conversationContexts = sessionContext.get(this.conversationStorageBean);
            } else {
                CreationalContext creationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.conversationStorageBean);
                conversationContexts = sessionContext.get(this.conversationStorageBean, creationalContext);
            }
        }
        return conversationContexts;
    }
}

