/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.johnzon.core.AbstractJsonFactory;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonWriterImpl;

class JsonWriterFactoryImpl
extends AbstractJsonFactory
implements JsonWriterFactory {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList(new String[0]);
    private final JsonGeneratorFactory factory;

    JsonWriterFactoryImpl(Map<String, ?> config) {
        super(config, SUPPORTED_CONFIG_KEYS, JsonGeneratorFactoryImpl.SUPPORTED_CONFIG_KEYS);
        this.factory = new JsonGeneratorFactoryImpl(this.internalConfig);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(this.factory.createGenerator(writer));
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out, UTF8_CHARSET));
    }

    @Override
    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

