/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.webserver.tomcat;

import io.yupiik.uship.webserver.tomcat.TomcatWebServerConfiguration;
import io.yupiik.uship.webserver.tomcat.loader.LaunchingClassLoaderLoader;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.CharArrayWriter;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.tomcat.util.modeler.Registry;

public class TomcatWebServer
implements AutoCloseable {
    private final TomcatWebServerConfiguration configuration;
    private Tomcat tomcat;

    protected TomcatWebServer() {
        this(null);
    }

    public TomcatWebServer(TomcatWebServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public int getPort() {
        return ((AbstractProtocol)AbstractProtocol.class.cast(this.tomcat.getConnector().getProtocolHandler())).getLocalPort();
    }

    public synchronized TomcatWebServer create() {
        if (this.configuration.isDisableRegistry()) {
            Registry.disableRegistry();
        }
        Tomcat tomcat = this.createTomcat();
        tomcat.getHost().addChild(this.createContext());
        if (this.configuration.getPort() == 0) {
            this.configuration.setPort(this.getPort());
        }
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.tomcat == null) {
            return;
        }
        try {
            this.tomcat.stop();
            this.tomcat.destroy();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Tomcat createTomcat() {
        Tomcat tomcat = this.newTomcat();
        tomcat.setBaseDir(this.configuration.getBase());
        tomcat.setPort(this.configuration.getPort());
        StandardHost host = new StandardHost();
        host.setName(this.configuration.getDefaultHost());
        tomcat.getEngine().addChild(host);
        if (this.configuration.getTomcatCustomizers() != null) {
            this.configuration.getTomcatCustomizers().forEach(c -> c.accept(tomcat));
        }
        this.onTomcat(tomcat);
        try {
            tomcat.init();
            tomcat.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException(e);
        }
        this.tomcat = tomcat;
        return this.tomcat;
    }

    protected StandardContext createContext() {
        StandardContext ctx = this.newContext();
        ctx.setLoader(new LaunchingClassLoaderLoader());
        ctx.setPath("");
        ctx.setName("");
        ctx.addServletContainerInitializer((set, servletContext) -> this.defaultContextSetup(servletContext), null);
        this.configuration.getInitializers().forEach(sci -> ctx.addServletContainerInitializer((ServletContainerInitializer)sci, Optional.ofNullable(sci.getClass().getAnnotation(HandlesTypes.class)).map(HandlesTypes::value).map(this::scanFor).orElseGet(Set::of)));
        ctx.addLifecycleListener(new Tomcat.FixContextListener());
        ErrorReportValve errorReportValve = new ErrorReportValve();
        errorReportValve.setShowReport(false);
        errorReportValve.setShowServerInfo(false);
        if (this.configuration.getAccessLogPattern() != null && !this.configuration.getAccessLogPattern().isBlank()) {
            AccessLogValve logValve = new AccessLogValve();
            logValve.setPattern(this.configuration.getAccessLogPattern());
            ctx.getPipeline().addValve(logValve);
        }
        ctx.getPipeline().addValve(errorReportValve);
        ctx.setClearReferencesObjectStreamClassCaches(false);
        ctx.setClearReferencesThreadLocals(false);
        ctx.setClearReferencesRmiTargets(false);
        if (this.configuration.getContextCustomizers() != null) {
            this.configuration.getContextCustomizers().forEach(c -> c.accept(ctx));
        }
        this.onContext(ctx);
        return ctx;
    }

    protected Tomcat newTomcat() {
        return new NoBaseDirTomcat();
    }

    protected StandardContext newContext() {
        return new NoWorkDirContext();
    }

    protected void onTomcat(Tomcat tomcat) {
    }

    protected void onContext(StandardContext ctx) {
    }

    protected Set<Class<?>> scanFor(Class<?> ... classes) {
        return Set.of();
    }

    protected void defaultContextSetup(ServletContext servletContext) {
        if (this.configuration.isSkipUtf8Filter()) {
            return;
        }
        FilterRegistration.Dynamic encodingFilter = servletContext.addFilter("default-utf8-filter", (servletRequest, servletResponse, filterChain) -> {
            servletRequest.setCharacterEncoding("UTF-8");
            servletResponse.setCharacterEncoding("UTF-8");
            filterChain.doFilter(servletRequest, servletResponse);
        });
        encodingFilter.setAsyncSupported(true);
        encodingFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, "/*");
    }

    private static class NoWorkDirContext
    extends StandardContext {
        private NoWorkDirContext() {
        }

        @Override
        protected void postWorkDirectory() {
        }
    }

    private static class NoBaseDirTomcat
    extends Tomcat {
        private NoBaseDirTomcat() {
        }

        @Override
        protected void initBaseDir() {
        }
    }

    private static class AccessLogValve
    extends AbstractAccessLogValve {
        private final Logger logger = Logger.getLogger("yupiik.webserver.tomcat.access.log");

        private AccessLogValve() {
        }

        @Override
        protected void log(CharArrayWriter message) {
            this.logger.info(message.toString());
        }
    }
}

