/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.webserver.cdi;

import io.yupiik.uship.webserver.tomcat.TomcatWebServer;
import io.yupiik.uship.webserver.tomcat.TomcatWebServerConfiguration;
import io.yupiik.uship.webserver.tomcat.customizer.ContextCustomizer;
import io.yupiik.uship.webserver.tomcat.customizer.TomcatCustomizer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.servlet.ServletContainerInitializer;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.catalina.startup.Tomcat;

@ApplicationScoped
public class TomcatWebServerProducer {
    public void start(@Observes @Initialized(value=ApplicationScoped.class) Object init, TomcatWebServer server) {
        server.getTomcat();
    }

    @Produces
    @ApplicationScoped
    public TomcatWebServer tomcatWebServer(Instance<TomcatWebServerConfiguration> configuration, Instance<ServletContainerInitializer> initializers, Instance<TomcatCustomizer> tomcatCustomizers, Instance<ContextCustomizer> contextCustomizers) {
        TomcatWebServerConfiguration serverConfiguration = configuration.isResolvable() ? (TomcatWebServerConfiguration)configuration.get() : new TomcatWebServerConfiguration();
        serverConfiguration.setInitializers(Stream.concat(serverConfiguration.getInitializers().stream(), initializers.stream()).distinct().collect(Collectors.toList()));
        serverConfiguration.setTomcatCustomizers(this.merge(serverConfiguration.getTomcatCustomizers(), tomcatCustomizers));
        serverConfiguration.setContextCustomizers(this.merge(serverConfiguration.getContextCustomizers(), contextCustomizers));
        return new TomcatWebServer(serverConfiguration).create();
    }

    public void destroyServer(@Disposes TomcatWebServer server) {
        server.close();
    }

    @Produces
    public Tomcat tomcat(TomcatWebServer server) {
        return server.getTomcat();
    }

    private <T> List<Consumer<T>> merge(List<Consumer<T>> first, Instance<? extends Consumer<T>> second) {
        return Stream.concat(first != null ? first.stream() : Stream.empty(), second.stream()).collect(Collectors.toList());
    }
}

