/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc;

import io.yupiik.uship.backbone.johnzon.jsonschema.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class JsonSchema2Adoc
implements Supplier<StringBuilder> {
    private final String levelPrefix;
    private final Schema schema;
    private final Predicate<Schema> shouldIgnore;

    public JsonSchema2Adoc(String levelPrefix, Schema schema, Predicate<Schema> shouldIgnore) {
        this.levelPrefix = levelPrefix;
        this.schema = schema;
        this.shouldIgnore = shouldIgnore;
    }

    public void prepare(Schema in) {
        Schema schema = Optional.ofNullable(in).orElse(this.schema);
        switch (schema.getType()) {
            case string: 
            case integer: 
            case number: 
            case bool: {
                break;
            }
            case object: {
                Map<String, Schema> properties = schema.getProperties();
                if (properties == null || properties.isEmpty()) break;
                properties.values().forEach(this::prepare);
                break;
            }
            case array: {
                if (schema.getItems() == null) {
                    throw new IllegalArgumentException("No items in array schema:\n" + schema);
                }
                if (schema.getItems().getTitle() == null) {
                    schema.getItems().setTitle(schema.getTitle());
                }
                if (schema.getItems().getDescription() == null) {
                    schema.getItems().setDescription(schema.getDescription());
                }
                if (schema.getTitle() == null) {
                    schema.setTitle(schema.getItems().getTitle());
                }
                if (schema.getDescription() == null) {
                    schema.setDescription(schema.getItems().getDescription());
                }
                if (schema.getItems().getType() != Schema.SchemaType.object) break;
                this.prepare(schema.getItems());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown schema type: " + schema.getType());
            }
        }
    }

    @Override
    public StringBuilder get() {
        if (this.shouldIgnore.test(this.schema)) {
            return new StringBuilder();
        }
        String title = Objects.requireNonNull(this.schema.getTitle(), "missing title");
        String description = Objects.requireNonNull(this.schema.getDescription(), "missing description");
        StringBuilder main = new StringBuilder();
        main.append(this.levelPrefix).append(' ').append(title).append("\n\n");
        if (!description.isEmpty()) {
            main.append(description).append("\n\n");
        }
        switch (this.schema.getType()) {
            case string: 
            case integer: 
            case number: 
            case bool: {
                break;
            }
            case object: {
                Map<String, Schema> properties = this.schema.getProperties();
                if (properties == null || properties.isEmpty()) break;
                Map primitives = properties.entrySet().stream().filter(it -> ((Schema)it.getValue()).getType() != Schema.SchemaType.array && ((Schema)it.getValue()).getType() != Schema.SchemaType.object).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
                Map nestedObjects = properties.entrySet().stream().filter(it -> ((Schema)it.getValue()).getType() == Schema.SchemaType.object).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
                Map nestedArrays = properties.entrySet().stream().filter(it -> ((Schema)it.getValue()).getType() == Schema.SchemaType.array).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
                main.append("[cols=\"2,2m,1,5\", options=\"header\"]\n.").append(title).append("\n|===\n").append("|Name|JSON Name|Type|Description\n");
                primitives.forEach((name, schema) -> main.append('|').append((String)name).append('|').append((String)name).append('|').append((Object)schema.getType()).append('|').append(this.toDescription((Schema)schema)).append(this.extractPotentialValues((Schema)schema)).append(this.extractDefaultValue((Schema)schema)).append('\n'));
                nestedArrays.entrySet().stream().filter(e -> ((Schema)e.getValue()).getItems().getType() != Schema.SchemaType.object).forEach(e -> main.append('|').append((String)e.getKey()).append('|').append((String)e.getKey()).append('|').append("array of ").append((Object)((Schema)e.getValue()).getItems().getType()).append('|').append(this.toDescription((Schema)e.getValue())).append('\n'));
                List validArrayKeys = nestedArrays.entrySet().stream().filter(e -> ((Schema)e.getValue()).getItems().getType() == Schema.SchemaType.object).filter(e -> {
                    boolean object = ((Schema)e.getValue()).getItems().getType() != Schema.SchemaType.object;
                    boolean ignoreObjectBlock = ((Schema)e.getValue()).getItems().getRef() != null;
                    String anchor = this.toAnchor(object ? ((Schema)e.getValue()).getItems() : (Schema)e.getValue());
                    main.append("|").append(anchor == null ? "" : "<<").append(anchor).append(anchor == null ? "" : ">>").append("|").append((String)e.getKey()).append('|').append("array of ").append((Object)((Schema)e.getValue()).getItems().getType()).append('|').append(((Schema)e.getValue()).getDescription() == null ? this.toDescription(((Schema)e.getValue()).getItems()) : this.toDescription((Schema)e.getValue())).append('\n');
                    return !ignoreObjectBlock;
                }).collect(Collectors.toList());
                List validObjectKeys = nestedObjects.entrySet().stream().filter(e -> {
                    boolean ignoreObjectBlock = ((Schema)e.getValue()).getRef() != null;
                    main.append("|");
                    String anchor = this.toAnchor((Schema)e.getValue());
                    if (anchor != null) {
                        main.append("<<").append(anchor).append(">>");
                    } else {
                        main.append((String)e.getKey());
                    }
                    main.append('|').append((String)e.getKey()).append('|').append((Object)((Schema)e.getValue()).getType()).append('|').append(this.toDescription((Schema)e.getValue())).append('\n');
                    return !ignoreObjectBlock;
                }).map(Map.Entry::getKey).collect(Collectors.toList());
                main.append("|===\n");
                if (!validObjectKeys.isEmpty()) {
                    main.append("\n");
                    nestedObjects.entrySet().stream().filter(e -> validObjectKeys.contains(e.getKey())).forEach(e -> {
                        String anchorBase = this.toAnchor((Schema)e.getValue());
                        StringBuilder content = new JsonSchema2Adoc(this.getNextLevelPrefix(), (Schema)e.getValue(), this.shouldIgnore).get();
                        if (anchorBase != null && content.length() > 0) {
                            main.append("[#").append(anchorBase).append("]\n").append((CharSequence)content).append("\n\n");
                        }
                    });
                }
                if (validArrayKeys.isEmpty()) break;
                main.append("\n");
                nestedArrays.entrySet().stream().filter(e -> ((Schema)e.getValue()).getItems().getType() == Schema.SchemaType.object).forEach(e -> {
                    Schema items = ((Schema)e.getValue()).getItems();
                    String anchorBase = this.toAnchor(items);
                    StringBuilder content = new JsonSchema2Adoc(this.getNextLevelPrefix(), items, this.shouldIgnore).get();
                    if (anchorBase != null && content.length() > 0) {
                        main.append("[#").append(anchorBase).append("]\n").append((CharSequence)content).append("\n\n");
                    }
                });
                break;
            }
            case array: {
                throw new IllegalArgumentException("Arrays shouldn't be root configuration and are handled in previous cases. You shouldn't be able to end up there.");
            }
            default: {
                throw new IllegalArgumentException("Unknown schema type: " + this.schema.getType());
            }
        }
        return main;
    }

    private String extractDefaultValue(Schema schema) {
        return schema.getDefaultValue() != null ? " Default Value: `" + String.valueOf(schema.getDefaultValue()).replace("|", "\\|") + "`." : "";
    }

    private String extractPotentialValues(Schema schema) {
        return schema.getEnumeration() != null && !schema.getEnumeration().isEmpty() ? this.toEnumValues(schema) : "";
    }

    private String toEnumValues(Schema schema) {
        Class<? extends Enum<?>> enumClass = this.tryToLoadEnum(schema.getId());
        return " Potential values: " + String.join((CharSequence)",", schema.getEnumeration().stream().map(it -> "`" + it + "`" + this.findCommentForEnumValue(enumClass, String.valueOf(it))).collect(Collectors.joining(","))) + ".";
    }

    private String toDescription(Schema schema) {
        return schema.getDescription().isEmpty() ? "-" : schema.getDescription().replace("|", "\\|");
    }

    private String findCommentForEnumValue(Class<? extends Enum<?>> enumClass, String value) {
        return "";
    }

    private Class<? extends Enum<?>> tryToLoadEnum(String id) {
        StringBuilder builder = new StringBuilder();
        boolean seenClass = false;
        for (String s : id.split("_")) {
            if (builder.length() > 0) {
                if (seenClass) {
                    builder.append('$');
                } else {
                    builder.append('.');
                    seenClass = Character.isUpperCase(s.charAt(0));
                }
            }
            builder.append(s);
        }
        String fqn = builder.toString();
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fqn);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).warning(() -> "Can't load '" + fqn + "' (" + id + ")");
            return null;
        }
    }

    private String getNextLevelPrefix() {
        return this.levelPrefix.length() >= 2 ? this.levelPrefix : this.levelPrefix + "=";
    }

    private String toAnchor(Schema schema) {
        String ref = schema.getType() == Schema.SchemaType.array ? Optional.ofNullable(schema.getItems().getId()).orElseGet(() -> schema.getItems().getRef()) : Optional.ofNullable(schema.getId()).orElseGet(schema::getRef);
        if (ref == null) {
            return null;
        }
        return ref.substring(ref.lastIndexOf(47) + 1).replaceFirst("#/", "").replace('/', '_');
    }
}

