/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc;

import io.yupiik.uship.backbone.johnzon.jsonschema.Schema;
import io.yupiik.uship.backbone.johnzon.jsonschema.SchemaProcessor;
import io.yupiik.uship.backbone.reflect.Reflections;
import io.yupiik.uship.jsonrpc.core.impl.Registration;
import io.yupiik.uship.jsonrpc.doc.BaseJsonRpcDocumentationGenerator;
import io.yupiik.uship.jsonrpc.doc.CliSibling;
import io.yupiik.uship.jsonrpc.doc.JsonSchema2Adoc;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AsciidoctorJsonRpcDocumentationGenerator
extends BaseJsonRpcDocumentationGenerator {
    private final String title;
    private Collection<Class<?>> schemas;

    public AsciidoctorJsonRpcDocumentationGenerator(String title, Collection<Class<?>> endpoints, PrintStream output) {
        super(endpoints, output);
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun(Stream<Registration> forRegistrations, PrintStream output) {
        block10: {
            if (this.title != null && !this.title.isEmpty()) {
                output.println("= " + this.title + "\n");
            }
            this.schemas = new HashSet();
            try {
                output.println("== JSON-RPC Methods\n");
                super.doRun(forRegistrations, output);
                if (this.schemas.isEmpty()) break block10;
                SchemaProcessor.InMemoryCache cache = new SchemaProcessor.InMemoryCache();
                try (SchemaProcessor schemaProcessor = new SchemaProcessor(true, true);){
                    this.schemas.stream().sorted(Comparator.comparing(Class::getName)).forEach(c -> schemaProcessor.mapSchemaFromClass((Type)c, cache));
                }
                HashSet visited = new HashSet();
                if (!cache.getSchemas().isEmpty()) {
                    output.println("== Model Schemas\n");
                }
                cache.getSchemas().entrySet().stream().sorted(Comparator.comparing(s -> ((Class)s.getKey()).getName())).forEach(e -> {
                    Schema schema = (Schema)e.getValue();
                    if (schema.getTitle() == null) {
                        schema.setTitle(((Class)e.getKey()).getName());
                    }
                    if (schema.getDescription() == null) {
                        schema.setDescription("");
                    }
                    var jsonSchema2Adoc = new JsonSchema2Adoc("===", schema, s -> s.getRef() != null || !visited.add(s)){

                        @Override
                        public void prepare(Schema in) {
                            if (in == null) {
                                super.prepare(in);
                                return;
                            }
                            if (in.getTitle() == null) {
                                in.setTitle("Model");
                            }
                            if (in.getDescription() == null) {
                                in.setDescription("");
                            }
                            super.prepare(in);
                        }
                    };
                    jsonSchema2Adoc.prepare(null);
                    String content = jsonSchema2Adoc.get().toString().trim();
                    if (!content.isEmpty()) {
                        output.println("[#" + schema.getId().replaceFirst("#/definitions/", "").replace('.', '_') + "]");
                        output.println(content);
                        output.println();
                    }
                });
            }
            finally {
                this.schemas.clear();
                this.schemas = null;
            }
        }
    }

    @Override
    protected String asString(Type type) {
        String string;
        if (Class.class.isInstance(type)) {
            Class clazz = (Class)Class.class.cast(type);
            if (!clazz.isPrimitive() && !clazz.getName().startsWith("java.")) {
                this.schemas.add(clazz);
            }
        } else if (ParameterizedType.class.isInstance(type)) {
            Stream.of(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments()).forEach(this::asString);
        }
        switch (string = super.asString(type)) {
            case "?": {
                return "Any";
            }
            case "javax.json.JsonStructure": {
                return "JSON structure (array or object)";
            }
        }
        return string;
    }

    @Override
    protected String toString(Registration registration) {
        return "=== " + registration.jsonRpcMethod() + "\n\n" + Optional.ofNullable(registration.documentation()).filter(it -> !it.isEmpty()).map(doc -> doc + "\n\n").orElse("") + (String)(registration.parameters().stream().noneMatch(it -> it.type() != HttpServletRequest.class && it.type() != HttpServletResponse.class) ? "" : "==== Parameters\n\n[options=\"header\"]\n|===\n|Name|Position|Type|Required|Documentation\n" + registration.parameters().stream().filter(it -> it.type() != HttpServletRequest.class && it.type() != HttpServletResponse.class).map(p -> "|" + p.name() + "|" + p.position() + "|" + this.asString(registration.clazz(), p.type()) + "|" + p.required() + "|" + Optional.ofNullable(p.documentation()).filter(it -> !it.isBlank()).orElse("-")).collect(Collectors.joining("\n")) + "\n|===\n\n") + "==== Result type\n\n`" + (this.isVoid(registration.returnedType()) ? "None" : this.asString(registration.clazz(), registration.returnedType())) + "`\n\n";
    }

    private String asString(Class<?> clazz, Type returnedType) {
        if (ParameterizedType.class.isInstance(returnedType)) {
            return this.asString(Reflections.resolveType(returnedType, clazz));
        }
        return this.asString(Reflections.extractRealType(clazz, returnedType));
    }

    private boolean isVoid(Type returnedType) {
        return returnedType == Void.class || returnedType == Void.TYPE;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            throw new IllegalArgumentException("Usage: java -cp ... " + AsciidoctorJsonRpcDocumentationGenerator.class.getName() + " <title> <jsonrpcclasses> <output>");
        }
        try (PrintStream output = CliSibling.toOutputStream(args[2]);){
            new AsciidoctorJsonRpcDocumentationGenerator(args[0], CliSibling.mapClasses(args[1]), output).run();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

