/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.core.impl;

import io.yupiik.uship.backbone.johnzon.Object2JsonSerializer;
import io.yupiik.uship.backbone.johnzon.jsonschema.Schema;
import io.yupiik.uship.backbone.johnzon.jsonschema.SchemaProcessor;
import io.yupiik.uship.backbone.reflect.Reflections;
import io.yupiik.uship.jsonrpc.core.api.JsonRpc;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcError;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcMethod;
import io.yupiik.uship.jsonrpc.core.api.JsonRpcParam;
import io.yupiik.uship.jsonrpc.core.impl.Registration;
import io.yupiik.uship.jsonrpc.core.lang.Tuple2;
import io.yupiik.uship.jsonrpc.core.openrpc.OpenRPC;
import io.yupiik.uship.jsonrpc.core.protocol.JsonRpcException;
import io.yupiik.uship.webserver.tomcat.TomcatWebServer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.json.spi.JsonProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;

@ApplicationScoped
public class JsonRpcMethodRegistry {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Object[] emptyArgs = new Object[0];
    private final JsonRpcError[] emptyExceptionArray = new JsonRpcError[0];
    private final Map<String, JsonRpcMethodRegistration> handlers = new ConcurrentHashMap<String, JsonRpcMethodRegistration>();
    @Inject
    private Jsonb jsonb;
    @Inject
    private JsonProvider jsonProvider;
    @Inject
    private TomcatWebServer server;
    @Inject
    @JsonRpc
    private Instance<Object> jsonRpcInstances;
    private OpenRPC openRPC;
    private Object2JsonSerializer toJsonValue;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.toJsonValue = new Object2JsonSerializer(this.jsonb);
        this.jsonRpcInstances.forEach(this::registerMethodFromService);
        this.registerOpenRPCMethod("openrpc");
        this.openRPC = this.doCreateOpenRpc();
    }

    public Map<String, JsonRpcMethodRegistration> getHandlers() {
        return this.handlers;
    }

    public Unregisterable registerMethod(Registration registration) {
        BiFunction<JsonObject, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> objectToArgs = this.mapObjectParams(registration.parameters());
        BiFunction<JsonArray, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> arrayToArgs = this.mapArrayParams(registration.parameters());
        Map<Class, Integer> handledEx = Optional.ofNullable(registration.exceptionMappings()).stream().flatMap(Collection::stream).flatMap(ex -> Optional.ofNullable(ex.types()).stream().flatMap(Collection::stream).map(e -> new AbstractMap.SimpleEntry<Class, Integer>((Class)e, ex.code()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Function<Throwable, JsonRpcException> exceptionMapper = exception -> this.handleException((Map<Class<? extends Throwable>, Integer>)handledEx, (Throwable)exception);
        boolean completionStage = this.isCompletionStage(registration.returnedType());
        BiFunction<JsonStructure, Tuple2, Object> invoke = (parameters, servlet) -> this.doInvoke(registration.invoker(), objectToArgs, arrayToArgs, exceptionMapper, (JsonStructure)parameters, (Tuple2<HttpServletRequest, HttpServletResponse>)servlet);
        Function<Object, JsonValue> resultMapper = this.createResultMapper(completionStage ? ((ParameterizedType)ParameterizedType.class.cast(registration.returnedType())).getActualTypeArguments()[0] : registration.returnedType());
        BiFunction<JsonStructure, Tuple2<HttpServletRequest, HttpServletResponse>, CompletionStage<JsonValue>> handler = !completionStage ? invoke.andThen(resultMapper).andThen(CompletableFuture::completedFuture) : invoke.andThen(stage -> ((CompletionStage)stage).handle((result, error) -> {
            if (error == null) {
                return (JsonValue)resultMapper.apply(result);
            }
            throw (JsonRpcException)exceptionMapper.apply(CompletionException.class.isInstance(error) && error.getCause() != null ? error.getCause() : error);
        }));
        String jsonRpcMethod = registration.jsonRpcMethod();
        JsonRpcMethodRegistration existing = this.handlers.get(jsonRpcMethod);
        if (existing != null && (existing.registration == null || existing.registration.method() == null || registration.method() == null)) {
            throw new IllegalArgumentException("Ambiguous method: '" + jsonRpcMethod + "'");
        }
        if (existing != null && existing.registration.method() != registration.method() && registration.method().getDeclaringClass().isAssignableFrom(existing.registration.method().getDeclaringClass())) {
            return () -> {};
        }
        this.logger.info(() -> "Registering '" + registration.jsonRpcMethod() + "'" + Optional.ofNullable(registration.clazz()).map(c -> " (" + c.getName() + "." + registration.method().getName() + ")").orElse("") + (existing != null ? " (override)" : ""));
        JsonRpcMethodRegistration jsonRpcMethodRegistration = new JsonRpcMethodRegistration(registration, handler);
        this.handlers.put(jsonRpcMethod, jsonRpcMethodRegistration);
        return () -> {
            this.handlers.remove(jsonRpcMethod, jsonRpcMethodRegistration);
            this.logger.info(() -> "Unregistered '" + jsonRpcMethod + "'");
        };
    }

    public Unregisterable registerMethodReflect(Object bean, Method method, JsonRpcMethod config, JsonRpcParam[] params, JsonRpcError[] exceptions) {
        if (!method.canAccess(bean)) {
            method.setAccessible(true);
        }
        Parameter[] types = method.getParameters();
        AtomicInteger paramIdx = new AtomicInteger(0);
        Class<?> declaringClass = this.extractClass(bean);
        String methodId = Optional.of(config.name()).filter(it -> !it.isEmpty()).orElse(method.getDeclaringClass().getName() + "." + method.getName());
        return this.registerMethod(new Registration(declaringClass, method, methodId, method.getGenericReturnType(), args -> this.doInvoke(bean, method, (Object[])args), Stream.of(params).map(p -> {
            int idx = paramIdx.getAndIncrement();
            Optional<JsonRpcParam> param = Optional.ofNullable(params[idx]);
            return new Registration.Parameter(Reflections.resolveType(types[idx].getParameterizedType(), declaringClass), param.map(JsonRpcParam::value).filter(it -> !it.isBlank()).orElseGet(types[idx]::getName), idx, param.map(JsonRpcParam::required).orElse(false), param.map(JsonRpcParam::documentation).orElse(""));
        }).collect(Collectors.toList()), Stream.of(exceptions).map(e -> new Registration.ExceptionMapping(Stream.of(e.handled()).collect(Collectors.toList()), e.code(), e.documentation())).collect(Collectors.toList()), config.documentation()));
    }

    private Class<?> extractClass(Object bean) {
        Class c;
        Class clazz = c = bean == null ? Object.class : bean.getClass();
        while (c != null && c.getName().contains("$$")) {
            c = c.getSuperclass();
        }
        return c == null ? Object.class : c;
    }

    protected OpenRPC doCreateOpenRpc() {
        OpenRPC.Info info = this.doCreateOpenRpcInfo();
        final OpenRPC.Components components = new OpenRPC.Components(new TreeMap<String, Schema>(), new TreeMap<String, OpenRPC.Link>(), new TreeMap<String, OpenRPC.ErrorValue>(), new TreeMap<String, OpenRPC.Tag>());
        try (SchemaProcessor schemaProcessor = new SchemaProcessor(false, false, v -> this.jsonb.fromJson((String)v, Schema.class));){
            SchemaProcessor.InMemoryCache componentsSchemaProcessorCache = new SchemaProcessor.InMemoryCache(){

                @Override
                public void onSchemaCreated(Class<?> type, Schema schema) {
                    super.onSchemaCreated(type, schema);
                    String ref = this.findRef(type);
                    if (ref != null) {
                        components.getSchemas().putIfAbsent(ref.substring(this.getRefPrefix().length()), schema);
                    }
                }

                @Override
                protected String getRefPrefix() {
                    return "#/components/schemas/";
                }
            };
            List<OpenRPC.RpcMethod> methods = this.handlers.entrySet().stream().map(arg_0 -> this.lambda$doCreateOpenRpc$17(schemaProcessor, componentsSchemaProcessorCache, arg_0)).collect(Collectors.toList());
            OpenRPC openRPC = new OpenRPC("1.2.4", info, this.toServers(), methods, components);
            return openRPC;
        }
    }

    protected List<OpenRPC.Server> toServers() {
        return List.of(new OpenRPC.Server("api", this.getBaseUrl(), "JSON-RPC API", Map.of()));
    }

    protected OpenRPC.RpcMethod toRpcMethod(SchemaProcessor schemaProcessor, SchemaProcessor.InMemoryCache componentsSchemaProcessorCache, Map.Entry<String, JsonRpcMethodRegistration> handler) {
        Registration reg = handler.getValue().registration();
        OpenRPC.Value result = new OpenRPC.Value(handler.getKey() + "__result", null, schemaProcessor.mapSchemaFromClass(this.unwrapType(reg.returnedType()), componentsSchemaProcessorCache), null, null);
        List<OpenRPC.ErrorValue> errors = reg.exceptionMappings() != null ? reg.exceptionMappings().stream().map(it -> new OpenRPC.ErrorValue(it.code(), it.documentation(), it.types() != null && !it.types().isEmpty() ? schemaProcessor.mapSchemaFromClass(it.types().iterator().next(), componentsSchemaProcessorCache) : null)).collect(Collectors.toList()) : null;
        List<OpenRPC.Value> params = reg.parameters() != null ? reg.parameters().stream().filter(p -> p.type() != HttpServletRequest.class && p.type() != HttpServletResponse.class).map(it -> new OpenRPC.Value(it.name(), it.documentation(), schemaProcessor.mapSchemaFromClass(it.type(), componentsSchemaProcessorCache), it.required(), null)).collect(Collectors.toList()) : null;
        return new OpenRPC.RpcMethod(handler.getKey(), List.of(), reg.documentation(), reg.documentation(), List.of(), params, result, null, null, errors, List.of(), "either", null);
    }

    private Type unwrapType(Type returnedType) {
        if (ParameterizedType.class.isInstance(returnedType)) {
            Class raw;
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(returnedType);
            if (Class.class.isInstance(pt.getRawType()) && (CompletionStage.class.isAssignableFrom(raw = (Class)Class.class.cast(pt.getRawType())) || Optional.class == raw)) {
                return pt.getActualTypeArguments()[0];
            }
            return pt;
        }
        return returnedType;
    }

    protected OpenRPC.Info doCreateOpenRpcInfo() {
        return new OpenRPC.Info("1.0", "JSON-RPC", null, null, null);
    }

    protected String getBaseUrl() {
        Tomcat tomcat = this.server.getTomcat();
        Connector connector = tomcat.getConnector();
        return connector.getScheme() + "://" + tomcat.getHost().getName() + ":" + ((AbstractProtocol)AbstractProtocol.class.cast(connector.getProtocolHandler())).getLocalPort() + "/jsonrpc";
    }

    public Unregisterable registerOpenRPCMethod(String methodId) {
        return this.registerMethod(new Registration(null, null, Objects.requireNonNull(methodId, "Method can't be null"), (Type)((Object)OpenRPC.class), ignored -> this.openRPC, (Collection<Registration.Parameter>)Collections.emptyList(), (Collection<Registration.ExceptionMapping>)Collections.emptyList(), "Returns the Open-RPC specification."));
    }

    public void registerMethodFromService(Object instance) {
        Class<?> clazz;
        for (clazz = instance.getClass(); clazz != null && clazz.getName().contains("$$"); clazz = clazz.getSuperclass()) {
        }
        this.registerMethodFromService(clazz == null ? instance.getClass() : clazz, instance);
    }

    public void registerMethodFromService(Class<?> type, Object instance) {
        Stream.of(type.getMethods()).filter(m -> m.isAnnotationPresent(JsonRpcMethod.class)).forEach(method -> this.registerMethodReflect(instance, (Method)method, method.getAnnotation(JsonRpcMethod.class), (JsonRpcParam[])Stream.of(method.getParameters()).map(p -> p.getAnnotation(JsonRpcParam.class)).toArray(JsonRpcParam[]::new), Optional.ofNullable((JsonRpcError[])method.getAnnotationsByType(JsonRpcError.class)).orElse(this.emptyExceptionArray)));
    }

    private Object doInvoke(Object bean, Method method, Object[] args) {
        try {
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new JsonRpcException(-32601, "Method can't be called", e);
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            if (JsonRpcException.class.isInstance(targetException)) {
                throw (JsonRpcException)JsonRpcException.class.cast(targetException);
            }
            if (RuntimeException.class.isInstance(targetException)) {
                throw (RuntimeException)RuntimeException.class.cast(targetException);
            }
            if (Error.class.isInstance(targetException)) {
                throw (Error)Error.class.cast(targetException);
            }
            throw new IllegalStateException(targetException);
        }
    }

    private JsonRpcException handleException(Map<Class<? extends Throwable>, Integer> handledEx, Throwable exception) {
        return JsonRpcException.class.isInstance(exception) ? (JsonRpcException)JsonRpcException.class.cast(exception) : handledEx.entrySet().stream().filter(handled -> ((Class)handled.getKey()).isAssignableFrom(exception.getClass())).findFirst().map(handled -> new JsonRpcException((Integer)handled.getValue(), exception.getMessage(), exception)).orElseGet(() -> new JsonRpcException(-32603, exception.getMessage(), exception));
    }

    private Function<Object, JsonValue> createResultMapper(Type genericReturnType) {
        if (ParameterizedType.class.isInstance(genericReturnType) && ((ParameterizedType)ParameterizedType.class.cast(genericReturnType)).getRawType() == Optional.class) {
            Function<Object, JsonValue> nestedMapper = this.createResultMapper(((ParameterizedType)ParameterizedType.class.cast(genericReturnType)).getActualTypeArguments()[0]);
            return v -> v == null || !((Optional)Optional.class.cast(v)).isPresent() ? null : (JsonValue)nestedMapper.apply(((Optional)Optional.class.cast(v)).get());
        }
        if (Class.class.isInstance(genericReturnType)) {
            Class clazz = (Class)Class.class.cast(genericReturnType);
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return v -> v == null ? null : this.jsonProvider.createValue(String.valueOf(v));
            }
            if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz) {
                return v -> v == null ? null : this.jsonProvider.createValue((Integer)Integer.class.cast(v));
            }
            if (Double.class.isAssignableFrom(clazz) || Double.TYPE == clazz) {
                return v -> v == null ? null : this.jsonProvider.createValue((Double)Double.class.cast(v));
            }
            if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz) {
                return v -> v == null ? null : (Boolean.TRUE.equals(v) ? JsonValue.TRUE : JsonValue.FALSE);
            }
        }
        return v -> v == null ? null : this.toJsonValue.apply(v);
    }

    private Object doInvoke(Function<Object[], Object> invoker, BiFunction<JsonObject, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> objectToArgs, BiFunction<JsonArray, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> arrayToArgs, Function<Throwable, JsonRpcException> exceptionMapper, JsonStructure parameters, Tuple2<HttpServletRequest, HttpServletResponse> servlet) {
        Object[] args = Optional.ofNullable(parameters).map(p -> {
            switch (p.getValueType()) {
                case OBJECT: {
                    return (Object[])objectToArgs.apply(p.asJsonObject(), servlet);
                }
                case ARRAY: {
                    return (Object[])arrayToArgs.apply(p.asJsonArray(), servlet);
                }
            }
            throw new JsonRpcException(-32601, "Unsupported params type: " + p.getValueType());
        }).orElseGet(() -> (Object[])arrayToArgs.apply(JsonValue.EMPTY_JSON_ARRAY, servlet));
        try {
            return invoker.apply(args);
        }
        catch (RuntimeException e) {
            throw exceptionMapper.apply(e);
        }
    }

    private BiFunction<JsonArray, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> mapArrayParams(Collection<Registration.Parameter> params) {
        if (params == null) {
            return (r, http) -> this.emptyArgs;
        }
        return this.optimize(params.stream().map(param -> {
            if (param.type() == HttpServletRequest.class) {
                return (json, http) -> http.first();
            }
            if (param.type() == HttpServletResponse.class) {
                return (json, http) -> http.second();
            }
            boolean optional = this.isOptional(param.type());
            BiFunction<JsonArray, Tuple2, JsonValue> jsExtractor = (request, http) -> request.size() > param.position() ? (JsonValue)request.get(param.position()) : null;
            BiFunction<JsonArray, Tuple2, JsonValue> validatedExtractor = !optional && param.required() ? (request, http) -> {
                JsonValue applied = (JsonValue)jsExtractor.apply((JsonArray)request, (Tuple2)http);
                if (applied == null) {
                    throw new JsonRpcException(-32601, "Missing #" + param.position() + " parameter.");
                }
                return applied;
            } : jsExtractor;
            return (request, http) -> this.mapToType(param.type(), optional, (JsonValue)validatedExtractor.apply((JsonArray)request, (Tuple2)http));
        }).collect(Collectors.toList()));
    }

    private BiFunction<JsonObject, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> mapObjectParams(Collection<Registration.Parameter> params) {
        if (params == null) {
            return (a, b) -> this.emptyArgs;
        }
        return this.optimize(params.stream().map(param -> {
            if (param.type() == HttpServletRequest.class) {
                return (json, http) -> http.first();
            }
            if (param.type() == HttpServletResponse.class) {
                return (json, http) -> http.second();
            }
            boolean optional = this.isOptional(param.type());
            BiFunction<JsonObject, Tuple2, JsonValue> jsExtractor = (request, http) -> (JsonValue)request.get(param.name());
            BiFunction<JsonObject, Tuple2, JsonValue> validatedExtractor = !optional && param.required() ? (request, http) -> {
                JsonValue applied = (JsonValue)jsExtractor.apply((JsonObject)request, (Tuple2)http);
                if (applied == null) {
                    throw new JsonRpcException(-32601, "Missing '" + param.name() + "' parameter.");
                }
                return applied;
            } : jsExtractor;
            return (request, http) -> this.mapToType(param.type(), optional, (JsonValue)validatedExtractor.apply((JsonObject)request, (Tuple2)http));
        }).collect(Collectors.toList()));
    }

    /*
     * Exception decompiling
     */
    private <A extends JsonStructure> BiFunction<A, Tuple2<HttpServletRequest, HttpServletResponse>, Object[]> optimize(Collection<BiFunction<A, Tuple2<HttpServletRequest, HttpServletResponse>, Object>> mappers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object mapToType(Type expectedType, boolean optional, JsonValue apply) {
        if (apply == null) {
            return optional ? Optional.empty() : null;
        }
        if (apply.getValueType() == JsonValue.ValueType.NULL) {
            if (expectedType == Integer.TYPE) {
                return 0;
            }
            if (expectedType == Long.TYPE) {
                return 0L;
            }
            if (expectedType == Double.TYPE) {
                return 0.0;
            }
            if (expectedType == Boolean.TYPE) {
                return false;
            }
            return null;
        }
        if (expectedType == String.class && apply.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)JsonString.class.cast(apply)).getString();
        }
        if ((expectedType == Long.TYPE || expectedType == Long.class) && apply.getValueType() == JsonValue.ValueType.NUMBER) {
            return ((JsonNumber)JsonNumber.class.cast(apply)).longValue();
        }
        if ((expectedType == Integer.TYPE || expectedType == Integer.class) && apply.getValueType() == JsonValue.ValueType.NUMBER) {
            return ((JsonNumber)JsonNumber.class.cast(apply)).intValue();
        }
        if ((expectedType == Double.TYPE || expectedType == Double.class) && apply.getValueType() == JsonValue.ValueType.NUMBER) {
            return ((JsonNumber)JsonNumber.class.cast(apply)).doubleValue();
        }
        if (!(expectedType != Boolean.TYPE && expectedType != Boolean.class || apply.getValueType() != JsonValue.ValueType.TRUE && apply.getValueType() != JsonValue.ValueType.FALSE)) {
            return JsonValue.TRUE.equals(apply);
        }
        if (Class.class.isInstance(expectedType) && ((Class)Class.class.cast(expectedType)).isEnum() && apply.getValueType() == JsonValue.ValueType.STRING) {
            return Enum.valueOf((Class)Class.class.cast(expectedType), ((JsonString)JsonString.class.cast(apply)).getString());
        }
        return this.jsonb.fromJson(apply.toString(), expectedType);
    }

    private boolean isCompletionStage(Type expectedType) {
        if (ParameterizedType.class.isInstance(expectedType)) {
            Type rawType = ((ParameterizedType)ParameterizedType.class.cast(expectedType)).getRawType();
            return Class.class.isInstance(rawType) && CompletionStage.class.isAssignableFrom((Class)Class.class.cast(rawType));
        }
        return false;
    }

    private boolean isOptional(Type expectedType) {
        return ParameterizedType.class.isInstance(expectedType) && ((ParameterizedType)ParameterizedType.class.cast(expectedType)).getRawType() == Optional.class;
    }

    private static /* synthetic */ Object[] lambda$optimize$55(Collection mappers, JsonStructure p, Tuple2 r) {
        return mappers.stream().map(fn -> fn.apply(p, r)).toArray(Object[]::new);
    }

    private /* synthetic */ OpenRPC.RpcMethod lambda$doCreateOpenRpc$17(SchemaProcessor schemaProcessor, 1 componentsSchemaProcessorCache, Map.Entry handler) {
        return this.toRpcMethod(schemaProcessor, componentsSchemaProcessorCache, handler);
    }

    public static class JsonRpcMethodRegistration {
        private final Registration registration;
        private final BiFunction<JsonStructure, Tuple2<HttpServletRequest, HttpServletResponse>, CompletionStage<JsonValue>> executor;

        public JsonRpcMethodRegistration(Registration registration, BiFunction<JsonStructure, Tuple2<HttpServletRequest, HttpServletResponse>, CompletionStage<JsonValue>> executor) {
            this.registration = registration;
            this.executor = executor;
        }

        public Registration registration() {
            return this.registration;
        }

        public BiFunction<JsonStructure, Tuple2<HttpServletRequest, HttpServletResponse>, CompletionStage<JsonValue>> executor() {
            return this.executor;
        }
    }

    @FunctionalInterface
    public static interface Unregisterable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

