/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.core.impl;

import io.yupiik.uship.backbone.johnzon.Object2JsonSerializer;
import io.yupiik.uship.jsonrpc.core.impl.JsonRpcMethodRegistry;
import io.yupiik.uship.jsonrpc.core.lang.Tuple2;
import io.yupiik.uship.jsonrpc.core.protocol.JsonRpcException;
import io.yupiik.uship.jsonrpc.core.protocol.Response;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

@ApplicationScoped
public class JsonRpcHandler {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Inject
    private Jsonb jsonb;
    @Inject
    private JsonRpcMethodRegistry registry;
    private Object2JsonSerializer toJsonValue;

    @PostConstruct
    private void init() {
        this.toJsonValue = new Object2JsonSerializer(this.jsonb);
    }

    public JsonStructure readRequest(Reader reader) throws IOException {
        try (Reader in = reader;){
            JsonStructure jsonStructure = this.jsonb.fromJson(in, JsonStructure.class);
            return jsonStructure;
        }
    }

    private void forwardResponse(Object payload, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.addHeader("content-type", "application/json;charset=utf-8");
        try (PrintWriter out = resp.getWriter();){
            this.jsonb.toJson(payload, out);
        }
    }

    public CompletionStage<Response> handleRequest(JsonObject request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return this.doValidate(request).map(CompletableFuture::completedFuture).orElseGet(() -> this.doHandle(request, httpRequest, httpResponse));
    }

    public CompletableFuture<Response> doHandle(JsonObject request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String method = request.getString("method");
        BiFunction<JsonStructure, Tuple2<HttpServletRequest, HttpServletResponse>, CompletionStage<JsonValue>> fn = this.registry.getHandlers().get(method).executor();
        JsonValue id = (JsonValue)request.get("id");
        JsonStructure params = Optional.ofNullable((JsonValue)request.get("params")).map(JsonStructure.class::cast).orElse(null);
        if (servletRequest != null) {
            this.appendJsonRpcMethod(servletRequest, method);
        }
        try {
            return fn.apply(params, new Tuple2<HttpServletRequest, HttpServletResponse>(servletRequest, servletResponse)).handle((result, error) -> {
                if (error != null) {
                    return this.toErrorResponse(id, CompletionException.class.isInstance(error) && error.getCause() != null ? error.getCause() : error, request);
                }
                return new Response("2.0", id, (JsonValue)result, null);
            }).toCompletableFuture();
        }
        catch (RuntimeException re) {
            return CompletableFuture.completedFuture(this.toErrorResponse(id, re, request));
        }
    }

    private void appendJsonRpcMethod(HttpServletRequest httpRequest, String method) {
        String existing = (String)String.class.cast(httpRequest.getAttribute("yupiik.jsonrpc.method"));
        if (existing == null) {
            httpRequest.setAttribute("yupiik.jsonrpc.method", method);
        } else {
            httpRequest.setAttribute("yupiik.jsonrpc.method", existing + "," + method);
        }
    }

    public Response toErrorResponse(JsonValue id, Throwable re, JsonStructure request) {
        Response.ErrorResponse errorResponse;
        if (JsonRpcException.class.isInstance(re)) {
            JsonRpcException jsonRpcException = (JsonRpcException)JsonRpcException.class.cast(re);
            Object data = jsonRpcException.getData();
            errorResponse = new Response.ErrorResponse(jsonRpcException.getCode(), re.getMessage(), data == null || JsonValue.class.isInstance(data) ? (JsonValue)JsonValue.class.cast(data) : this.toJsonValue.apply(data));
        } else {
            errorResponse = new Response.ErrorResponse(-2, re.getMessage(), null);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.SEVERE, "An error occured calling /jsonrpc '" + request + "'", re);
        } else {
            this.logger.log(Level.SEVERE, "An error occured calling /jsonrpc, " + (request.getValueType() == JsonValue.ValueType.OBJECT ? "method=" + request.asJsonObject().get("method") : request), re);
        }
        return new Response("2.0", id, null, errorResponse);
    }

    public Optional<Response> doValidate(JsonObject request) {
        Tuple2<String, Response> pair = this.ensurePresent(request, "jsonrpc", -32600);
        if (pair.second() != null) {
            return Optional.of(pair.second());
        }
        if (!"2.0".equals(pair.first())) {
            return Optional.of(this.createResponse(request, -32600, "invalid jsonrpc version"));
        }
        Tuple2<String, Response> method = this.ensurePresent(request, "method", -32601);
        if (method.second() != null) {
            return Optional.of(method.second());
        }
        if (!this.registry.getHandlers().containsKey(method.first())) {
            return Optional.of(this.createResponse(request, -32601, "Unknown method (" + method.first() + ")"));
        }
        return Optional.empty();
    }

    private Tuple2<String, Response> ensurePresent(JsonObject request, String key, int code) {
        JsonString methodJson = request.getJsonString(key);
        if (methodJson == null) {
            return new Tuple2<Object, Response>(null, this.createResponse(request, code, "Missing " + key));
        }
        String method = methodJson.getString();
        if (method.isEmpty()) {
            return new Tuple2<Object, Response>(null, this.createResponse(request, code, "Empty " + key));
        }
        return new Tuple2<String, Object>(method, null);
    }

    public Response createResponse(JsonObject request, int code, String message) {
        JsonValue id = request == null ? null : (JsonValue)request.get("id");
        return new Response("2.0", id, null, new Response.ErrorResponse(code, message, null));
    }

    public CompletionStage<?> execute(JsonStructure request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        switch (request.getValueType()) {
            case OBJECT: {
                return this.handleRequest(request.asJsonObject(), httpRequest, httpResponse);
            }
            case ARRAY: {
                JsonArray requests = request.asJsonArray();
                if (requests.size() > 50) {
                    return CompletableFuture.completedFuture(this.toErrorResponse(null, new JsonRpcException(10100, "Too much request at once, limit it to 50 max please.", null), request));
                }
                CompletableFuture[] futures = (CompletableFuture[])requests.stream().map(it -> it.getValueType() == JsonValue.ValueType.OBJECT ? this.handleRequest(it.asJsonObject(), httpRequest, httpResponse) : CompletableFuture.completedFuture(this.createResponse(it.asJsonObject(), -32600, "Batch requests must be JSON objects"))).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(futures).thenApply(ignored -> (Response[])Stream.of(futures).map(f -> f.getNow(null)).toArray(Response[]::new));
            }
        }
        return CompletableFuture.completedFuture(this.createResponse(null, -32600, "Unknown request type: " + request.getValueType()));
    }

    public static interface Constants {
        public static final String REQUEST_METHOD_ATTRIBUTE = "yupiik.jsonrpc.method";
    }
}

