/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.MJarSupport;

public class JarArchive
implements Archive,
AutoCloseable {
    private final ClassLoader loader;
    private final URL url;
    private final JarFile jar;
    private final MJarSupport mjar = new MJarSupport();

    public JarArchive(ClassLoader loader, URL url) {
        String jarPath;
        this.loader = loader;
        this.url = url;
        File jarFile = null;
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            try {
                jarPath = url.getPath();
                url = new URL(jarPath.endsWith("!/") ? jarPath.substring(0, jarPath.lastIndexOf("!/")) : jarPath);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Please provide 'file:/...' or 'jar:file:/...!/' URL instead of '" + FileArchive.decode(String.valueOf(url)) + "'");
            }
        }
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                int idx = 0;
                String jp = jarPath = FileArchive.decode(url.getPath());
                while (!(jarFile = new File(jp)).exists() && (idx = jarPath.indexOf("!/", idx + 1)) > 0) {
                    jp = jarPath.substring(0, idx);
                }
                if (!jarFile.exists()) {
                    throw new FileNotFoundException(FileArchive.decode(String.valueOf(url)));
                }
            } else {
                throw new IllegalArgumentException("Please provide 'file:/...' or 'jar:file:/...!/' URL instead of '" + FileArchive.decode(String.valueOf(url)) + "'");
            }
            this.jar = new JarFile(jarFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open jar(zip) '" + jarFile != null ? jarFile.getAbsolutePath() : FileArchive.decode(String.valueOf(url)) + "'", e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        ZipEntry entry;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((entry = this.jar.getEntry(className)) == null) {
            throw new ClassNotFoundException(className);
        }
        return this.jar.getInputStream(entry);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return new JarIterator();
    }

    @Override
    public void close() throws Exception {
        this.jar.close();
    }

    private class JarIterator
    implements Iterator<Archive.Entry> {
        private final Iterator<JarEntry> stream;
        private Archive.Entry next;

        private JarIterator() {
            Enumeration<JarEntry> entries = JarArchive.this.jar.entries();
            try {
                Manifest manifest = JarArchive.this.jar.getManifest();
                if (manifest != null) {
                    JarArchive.this.mjar.load(manifest);
                }
            }
            catch (IOException manifest) {
                // empty catch block
            }
            if (JarArchive.this.mjar.isMjar()) {
                ArrayList<JarEntry> list = new ArrayList<JarEntry>(Collections.list(entries));
                Collections.sort(list, new Comparator<JarEntry>(){

                    @Override
                    public int compare(JarEntry o1, JarEntry o2) {
                        String n2 = o2.getName();
                        String n1 = o1.getName();
                        boolean n1v = n1.startsWith("META-INF/versions/");
                        boolean n2v = n2.startsWith("META-INF/versions/");
                        if (n1v && n2v) {
                            return n1.compareTo(n2);
                        }
                        if (n1v) {
                            return -1;
                        }
                        if (n2v) {
                            return 1;
                        }
                        try {
                            return Integer.parseInt(n2) - Integer.parseInt(n1);
                        }
                        catch (NumberFormatException nfe) {
                            return n2.compareTo(n1);
                        }
                    }
                });
                this.stream = list.iterator();
            } else {
                this.stream = Collections.list(entries).iterator();
            }
        }

        private boolean advance() {
            if (this.next != null) {
                return true;
            }
            while (this.stream.hasNext()) {
                JarEntry entry = this.stream.next();
                String entryName = entry.getName();
                if (entry.isDirectory() || !entryName.endsWith(".class") || entryName.endsWith("module-info.class")) continue;
                String className = entryName;
                if (entryName.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                if (className.contains(".") || entryName.startsWith("META-INF/versions/")) continue;
                this.next = new ClassEntry(entry, className.replace('/', '.'));
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.advance();
        }

        @Override
        public Archive.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Archive.Entry entry = this.next;
            this.next = null;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private class ClassEntry
        implements Archive.Entry {
            private final String name;
            private final JarEntry entry;

            private ClassEntry(JarEntry entry, String name) {
                this.name = name;
                this.entry = entry;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public InputStream getBytecode() throws IOException {
                JarEntry entry;
                if (JarArchive.this.mjar.isMjar() && (entry = JarArchive.this.jar.getJarEntry(this.entry.getName())) != null) {
                    return JarArchive.this.jar.getInputStream(entry);
                }
                return JarArchive.this.jar.getInputStream(this.entry);
            }
        }
    }
}

