/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.se;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.spi.ApplicationBoundaryService;

public class DefaultApplicationBoundaryService
implements ApplicationBoundaryService,
Closeable {
    private ClassLoader applicationClassLoader;
    private Set<ClassLoader> parentClassLoaders;

    public DefaultApplicationBoundaryService() {
        this.init();
    }

    protected void init() {
        this.applicationClassLoader = BeanManagerImpl.class.getClassLoader();
        this.parentClassLoaders = new HashSet<ClassLoader>();
        ClassLoader cl = this.applicationClassLoader;
        while (cl.getParent() != null) {
            cl = cl.getParent();
            this.parentClassLoaders.add(cl);
        }
    }

    @Override
    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public ClassLoader getBoundaryClassLoader(Class classToProxy) {
        ClassLoader appCl = this.getApplicationClassLoader();
        ClassLoader classToProxyCl = classToProxy.getClassLoader();
        if (classToProxyCl == null) {
            return appCl;
        }
        if (classToProxyCl == appCl) {
            return appCl;
        }
        if (this.isOutsideOfApplicationClassLoader(classToProxyCl)) {
            return appCl;
        }
        return classToProxyCl;
    }

    protected boolean isOutsideOfApplicationClassLoader(ClassLoader classToProxyClassLoader) {
        return this.parentClassLoaders.contains(classToProxyClassLoader);
    }

    @Override
    public void close() throws IOException {
        this.parentClassLoaders.clear();
    }
}

