/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner.xbean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.webbeans.corespi.scanner.xbean.BeanArchiveFilter;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;

public class CdiArchive
implements Archive {
    private final Map<String, FoundClasses> classesByUrl = new HashMap<String, FoundClasses>();
    private final Archive delegate;

    public CdiArchive(BeanArchiveService beanArchiveService, ClassLoader loader, Map<String, URL> urls, Filter userFilter, Archive customArchive) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        boolean customAdded = false;
        for (URL url : urls.values()) {
            ArrayList<String> urlClasses = new ArrayList<String>();
            BeanArchiveService.BeanArchiveInformation beanArchiveInfo = beanArchiveService.getBeanArchiveInformation(url);
            boolean custom = "openwebbeans".equals(url.getProtocol());
            FilteredArchive archive = new FilteredArchive(custom ? customArchive : ClasspathArchive.archive(loader, url), new BeanArchiveFilter(beanArchiveInfo, urlClasses, userFilter));
            if (!customAdded && custom) {
                customAdded = true;
            }
            this.classesByUrl.put(url.toExternalForm(), new FoundClasses(url, urlClasses, beanArchiveInfo));
            archives.add(archive);
        }
        if (!customAdded && customArchive != null) {
            archives.add(userFilter != null ? new FilteredArchive(customArchive, userFilter) : customArchive);
        }
        this.delegate = new CompositeArchive(archives);
    }

    public Map<String, FoundClasses> classesByUrl() {
        return this.classesByUrl;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.delegate.getBytecode(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.delegate.loadClass(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return this.delegate.iterator();
    }

    public static final class FoundClasses {
        private URL url;
        private Collection<String> classNames;
        private BeanArchiveService.BeanArchiveInformation beanArchiveInfo;

        public FoundClasses(URL url, Collection<String> classNames, BeanArchiveService.BeanArchiveInformation beanArchiveInfo) {
            this.url = url;
            this.classNames = classNames;
            this.beanArchiveInfo = beanArchiveInfo;
        }

        public URL getUrl() {
            return this.url;
        }

        public BeanArchiveService.BeanArchiveInformation getBeanArchiveInfo() {
            return this.beanArchiveInfo;
        }

        public Collection<String> getClassNames() {
            return this.classNames;
        }
    }
}

