/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.PassivationBeanWrapper;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.util.Asserts;

public class InjectionTargetBean<T>
extends AbstractOwbBean<T>
implements Serializable {
    private AnnotatedType<T> annotatedType;
    private InjectionTarget<T> injectionTarget;

    public InjectionTargetBean(WebBeansContext webBeansContext, WebBeansType webBeansType, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass) {
        this(webBeansContext, webBeansType, annotatedType, beanAttributes, beanClass, new InjectionTargetFactoryImpl<T>(annotatedType, webBeansContext));
    }

    public InjectionTargetBean(WebBeansContext webBeansContext, WebBeansType webBeansType, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass, InjectionTargetFactory<T> factory) {
        super(webBeansContext, webBeansType, beanAttributes, beanClass);
        Asserts.assertNotNull(annotatedType, "AnnotatedType");
        this.annotatedType = annotatedType;
        this.injectionTarget = factory.createInjectionTarget(this);
        this.setEnabled(true);
    }

    public void defineInterceptorsIfNeeded() {
        if (this.getProducer() instanceof AbstractProducer) {
            AbstractProducer producer = (AbstractProducer)this.getProducer();
            producer.defineInterceptorStack(this, this.annotatedType, this.webBeansContext);
        }
    }

    @Override
    protected String providedId() {
        return this.webBeansContext.getBeanManagerImpl().getId((Class)Class.class.cast(this.getBeanClass()), this.annotatedType);
    }

    @Override
    public InjectionTarget<T> getProducer() {
        return this.injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    private Object writeReplace() throws ObjectStreamException {
        String passivationId = this.getId();
        if (passivationId == null) {
            throw new NotSerializableException("Bean is about to be serialized and does not have any any PassivationCapable id: " + this.toString());
        }
        return new PassivationBeanWrapper(passivationId);
    }
}

