/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.util.AnnotationUtil;

public class BeanAttributesImpl<T>
implements BeanAttributes<T> {
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final Class<? extends Annotation> scope;
    private final String name;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final boolean alternative;

    public BeanAttributesImpl(Bean<T> bean) {
        this(bean.getTypes(), bean.getQualifiers(), bean.getScope(), bean.getName(), bean.getStereotypes(), bean.isAlternative());
    }

    public BeanAttributesImpl(BeanAttributes<T> beanAttributes) {
        this(beanAttributes.getTypes(), beanAttributes.getQualifiers(), beanAttributes.getScope(), beanAttributes.getName(), beanAttributes.getStereotypes(), beanAttributes.isAlternative());
    }

    public BeanAttributesImpl(Set<Type> types) {
        this(types, AnnotationUtil.DEFAULT_AND_ANY_ANNOTATION_SET, Dependent.class, null, Collections.emptySet(), false);
    }

    public BeanAttributesImpl(Set<Type> types, Set<Annotation> qualifiers) {
        this(types, qualifiers, Dependent.class, null, Collections.emptySet(), false);
    }

    public BeanAttributesImpl(Set<Type> types, Set<Annotation> qualifiers, Class<? extends Annotation> scope) {
        this(types, qualifiers, scope, null, Collections.emptySet(), false);
    }

    public BeanAttributesImpl(Set<Type> types, Set<Annotation> qualifiers, Class<? extends Annotation> scope, Set<Class<? extends Annotation>> stereotypes) {
        this(types, qualifiers, scope, null, stereotypes, false);
    }

    public BeanAttributesImpl(Set<Type> types, Set<Annotation> qualifiers, Class<? extends Annotation> scope, String name, Set<Class<? extends Annotation>> stereotypes, boolean alternative) {
        this.types = types == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<Type>(types));
        this.qualifiers = qualifiers == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<Annotation>(qualifiers));
        this.scope = scope;
        this.name = name;
        this.stereotypes = stereotypes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<Class<? extends Annotation>>(stereotypes));
        this.alternative = alternative;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return false;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public boolean isAlternative() {
        return this.alternative;
    }
}

