/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.backbone.reflect;

import io.yupiik.uship.backbone.reflect.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Reflections {
    private Reflections() {
    }

    public static Type resolveType(Type type, Class<?> declaringClass) {
        block6: {
            block7: {
                Type realType = Reflections.extractRealType(declaringClass, type);
                if (!ParameterizedType.class.isInstance(type)) break block6;
                if (realType != type) break block7;
                if (!Stream.of(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments()).anyMatch(TypeVariable.class::isInstance)) break block6;
            }
            return Reflections.resolveParameterizedType(type, declaringClass);
        }
        if (TypeVariable.class.isInstance(type) && declaringClass.getSuperclass() != null) {
            ParameterizedType pt;
            TypeVariable tv = (TypeVariable)TypeVariable.class.cast(type);
            TypeVariable<Class<?>>[] typeParameters = declaringClass.getSuperclass().getTypeParameters();
            if (typeParameters != null && ParameterizedType.class.isInstance(declaringClass.getGenericSuperclass()) && typeParameters.length == (pt = (ParameterizedType)ParameterizedType.class.cast(declaringClass.getGenericSuperclass())).getActualTypeArguments().length) {
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (tv != typeParameters[i]) continue;
                    return pt.getActualTypeArguments()[i];
                }
            }
        }
        return type;
    }

    private static Type resolveParameterizedType(Type type, Class<?> declaringClass) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
        Type resolvedParam = Reflections.resolveType(pt.getActualTypeArguments()[0], declaringClass);
        if (pt.getActualTypeArguments()[0] != resolvedParam) {
            return new ParameterizedTypeImpl(pt.getRawType(), resolvedParam);
        }
        return type;
    }

    public static Type extractRealType(Class<?> root, Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            return Stream.of(Optional.class, CompletionStage.class, CompletableFuture.class).anyMatch(gt -> pt.getRawType() == gt) ? (ParameterizedType.class.isInstance(pt.getActualTypeArguments()[0]) ? Reflections.resolveParameterizedType(pt.getActualTypeArguments()[0], root) : pt.getActualTypeArguments()[0]) : pt;
        }
        if (TypeVariable.class.isInstance(type)) {
            Map<Type, Type> resolution = Reflections.toResolvedTypes(root, 0);
            Type value = type;
            int max = 15;
            do {
                value = resolution.get(value);
            } while (--max > 0 && value != null && resolution.containsKey(value));
            return Optional.ofNullable(value).orElse(type);
        }
        return type;
    }

    private static Map<Type, Type> toResolvedTypes(Type clazz, int maxIt) {
        if (maxIt > 15) {
            return Collections.emptyMap();
        }
        if (Class.class.isInstance(clazz)) {
            return Reflections.toResolvedTypes(((Class)Class.class.cast(clazz)).getGenericSuperclass(), maxIt + 1);
        }
        if (ParameterizedType.class.isInstance(clazz)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(clazz);
            if (!Class.class.isInstance(parameterizedType.getRawType())) {
                return Collections.emptyMap();
            }
            Class raw = (Class)Class.class.cast(parameterizedType.getRawType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length > 0) {
                TypeVariable<Class<T>>[] parameters = raw.getTypeParameters();
                HashMap map = new HashMap(parameters.length);
                for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
                    map.put(parameters[i], arguments[i]);
                }
                return Stream.concat(map.entrySet().stream(), Reflections.toResolvedTypes(raw, maxIt + 1).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
            }
        }
        return Collections.emptyMap();
    }
}

