/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.util.List;
import java.util.Set;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.util.Asserts;

public class InjectionTargetFactoryImpl<T>
implements InjectionTargetFactory<T> {
    private final WebBeansContext webBeansContext;
    private AnnotatedType<T> annotatedType;
    private AnnotatedTypeConfiguratorImpl<T> annotatedTypeConfigurator;

    public InjectionTargetFactoryImpl(AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(annotatedType, "AnnotatedType");
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public InjectionTarget<T> createInjectionTarget() {
        return this.createInjectionTarget(null);
    }

    @Override
    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        AnnotatedType<T> at = this.getAnnotatedType();
        InjectionTargetImpl<T> injectionTarget = new InjectionTargetImpl<T>(at, this.createInjectionPoints(bean), this.webBeansContext, this.getPostConstructMethods(), this.getPreDestroyMethods());
        if (ManagedBean.class.isInstance(bean)) {
            ((ManagedBean)ManagedBean.class.cast(bean)).setOriginalInjectionTarget(injectionTarget);
        }
        GProcessInjectionTarget event = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(injectionTarget, at);
        InjectionTarget it = event.getInjectionTarget();
        event.setStarted();
        this.annotatedType = null;
        this.annotatedTypeConfigurator = null;
        return it;
    }

    public Set<InjectionPoint> createInjectionPoints(Bean<T> bean) {
        return this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.getAnnotatedType());
    }

    public AnnotatedType<T> getAnnotatedType() {
        if (this.annotatedTypeConfigurator != null) {
            return this.annotatedTypeConfigurator.getNewAnnotatedType();
        }
        return this.annotatedType;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected List<AnnotatedMethod<?>> getPostConstructMethods() {
        return this.webBeansContext.getInterceptorUtil().getLifecycleMethods(this.annotatedType, PostConstruct.class);
    }

    protected List<AnnotatedMethod<?>> getPreDestroyMethods() {
        return this.webBeansContext.getInterceptorUtil().getLifecycleMethods(this.annotatedType, PreDestroy.class);
    }

    @Override
    public AnnotatedTypeConfigurator<T> configure() {
        if (this.annotatedType == null) {
            throw new IllegalStateException("InjectionTargetFactora can only be used once");
        }
        this.annotatedTypeConfigurator = new AnnotatedTypeConfiguratorImpl<T>(this.webBeansContext, this.annotatedType);
        return this.annotatedTypeConfigurator;
    }
}

