/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openwebbeans.se.CDISeBeanArchiveService;
import org.apache.openwebbeans.se.CDISeLoaderService;
import org.apache.openwebbeans.se.CDISeScannerService;
import org.apache.openwebbeans.se.OWBContainer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.corespi.DefaultSingletonService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;

public class OWBInitializer
extends SeContainerInitializer {
    protected final CDISeScannerService scannerService = this.createDefaultScannerService();
    protected final Properties properties = new Properties();
    protected final Map<String, Object> services = new HashMap<String, Object>();
    protected final Collection<Extension> extensions = new ArrayList<Extension>();
    protected final DefaultBeanArchiveInformation bai = new DefaultBeanArchiveInformation("cdi-standalone");
    protected ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public OWBInitializer() {
        this.scannerService.loader(this.loader);
        if (Boolean.getBoolean("jakarta.enterprise.inject.scan.implicit")) {
            this.addProperty("org.apache.webbeans.scanBeansXmlOnly", true);
        }
    }

    protected CDISeScannerService createDefaultScannerService() {
        return new CDISeScannerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeContainer initialize() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            if (!this.properties.containsKey(ScannerService.class.getName())) {
                this.services.putIfAbsent(ScannerService.class.getName(), this.getScannerService());
            }
            if (!this.properties.containsKey(LoaderService.class.getName())) {
                this.services.putIfAbsent(LoaderService.class.getName(), new CDISeLoaderService(this.extensions, this.loader));
            }
            if (!this.properties.containsKey(BeanArchiveService.class.getName())) {
                this.services.putIfAbsent(BeanArchiveService.class.getName(), new CDISeBeanArchiveService(this.bai));
            }
            this.addCustomServices(this.services);
            Map<Class<?>, Object> preparedServices = this.services.entrySet().stream().collect(Collectors.toMap(e -> {
                try {
                    return this.loader.loadClass((String)e.getKey());
                }
                catch (ClassNotFoundException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }, Map.Entry::getValue));
            WebBeansContext context = new WebBeansContext(preparedServices, this.properties);
            SingletonService<WebBeansContext> singletonInstance = WebBeansFinder.getSingletonService();
            ((DefaultSingletonService)DefaultSingletonService.class.cast(singletonInstance)).register(this.loader, context);
            SeContainer seContainer = this.newContainer(context);
            return seContainer;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    protected void addCustomServices(Map<String, Object> services) {
    }

    protected SeContainer newContainer(WebBeansContext context) {
        Object startObj = new Object();
        context.getService(ContainerLifecycle.class).startApplication(startObj);
        return new OWBContainer(context, startObj);
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    @Override
    public SeContainerInitializer addBeanClasses(Class<?> ... classes) {
        this.scannerService.classes(classes);
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(Package ... packages) {
        return this.addPackages(false, packages);
    }

    @Override
    public SeContainerInitializer addPackages(boolean scanRecursively, Package ... packages) {
        this.scannerService.packages(scanRecursively, packages);
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(Class<?> ... packageClasses) {
        return this.addPackages(false, packageClasses);
    }

    @Override
    public SeContainerInitializer addPackages(boolean scanRecursively, Class<?> ... packageClasses) {
        this.scannerService.packages(scanRecursively, packageClasses);
        return this;
    }

    @Override
    public SeContainerInitializer enableInterceptors(Class<?> ... interceptorClasses) {
        this.bai.getInterceptors().addAll(Stream.of(interceptorClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SeContainerInitializer enableDecorators(Class<?> ... decoratorClasses) {
        this.bai.getDecorators().addAll(Stream.of(decoratorClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SeContainerInitializer selectAlternatives(Class<?> ... alternativeClasses) {
        this.bai.getAlternativeClasses().addAll(Stream.of(alternativeClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SeContainerInitializer selectAlternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        this.bai.getAlternativeStereotypes().addAll(Stream.of(alternativeStereotypeClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SeContainerInitializer addExtensions(Extension ... extensions) {
        this.extensions.addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public SeContainerInitializer addExtensions(Class<? extends Extension> ... extensions) {
        this.extensions.addAll(Stream.of(extensions).map(e -> {
            try {
                return (Extension)e.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e1) {
                throw new IllegalArgumentException(e1);
            }
            catch (InvocationTargetException e1) {
                throw new IllegalArgumentException(e1.getCause());
            }
        }).collect(Collectors.toList()));
        return this;
    }

    @Override
    public SeContainerInitializer addProperty(String key, Object value) {
        switch (key) {
            case "openwebbeans.disableDiscovery": {
                if (!"true".equalsIgnoreCase(String.valueOf(value))) break;
                this.disableDiscovery();
                break;
            }
            case "openwebbeans.classes": {
                this.addBeanClasses((Class[])this.list(value, this::loadClass).toArray(Class[]::new));
                break;
            }
            case "openwebbeans.interceptors": {
                this.enableInterceptors((Class[])this.list(value, this::loadClass).toArray(Class[]::new));
                break;
            }
            case "openwebbeans.decorators": {
                this.enableDecorators((Class[])this.list(value, this::loadClass).toArray(Class[]::new));
                break;
            }
            case "openwebbeans.alternatives": {
                this.selectAlternatives((Class[])this.list(value, this::loadClass).toArray(Class[]::new));
                break;
            }
            case "openwebbeans.stereotypes": {
                this.selectAlternativeStereotypes((Class[])this.list(value, this::loadClass).toArray(Class[]::new));
                break;
            }
            case "openwebbeans.extensions": {
                Class[] extensions = (Class[])this.list(value, this::loadClass).toArray(Class[]::new);
                this.addExtensions(extensions);
                break;
            }
            case "openwebbeans.packages": {
                this.addPackages((Package[])this.list(value, this::loadPackage).toArray(Package[]::new));
                break;
            }
            case "openwebbeans.packages.recursive": {
                this.addPackages(true, (Package[])this.list(value, this::loadPackage).toArray(Package[]::new));
                break;
            }
            case "openwebbeans.properties": {
                Properties properties = new Properties();
                try (StringReader reader = new StringReader(String.valueOf(value));){
                    properties.load(reader);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                properties.stringPropertyNames().forEach(k -> this.addProperty((String)k, properties.getProperty((String)k)));
                break;
            }
            case "openwebbeans.property.": {
                this.addProperty(key.substring("openwebbeans.property.".length()), value);
                break;
            }
            case "jakarta.enterprise.inject.scan.implicit": {
                this.addProperty("org.apache.webbeans.scanBeansXmlOnly", value);
                break;
            }
            default: {
                if (String.class.isInstance(value)) {
                    this.properties.put(key, value);
                    break;
                }
                this.services.put(key, value);
            }
        }
        return this;
    }

    @Override
    public SeContainerInitializer setProperties(Map<String, Object> properties) {
        properties.forEach(this::addProperty);
        return this;
    }

    @Override
    public SeContainerInitializer disableDiscovery() {
        this.scannerService.disableAutoScanning();
        return this;
    }

    @Override
    public SeContainerInitializer setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
        this.scannerService.loader(this.loader);
        return this;
    }

    private <T> Stream<T> list(Object list, Function<Object, T> mapper) {
        if (Collection.class.isInstance(list)) {
            return ((Collection)Collection.class.cast(list)).stream().map(mapper);
        }
        return Stream.of(String.valueOf(list).split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(mapper);
    }

    private Package loadPackage(Object obj) {
        if (Package.class.isInstance(obj)) {
            return (Package)Package.class.cast(obj);
        }
        String name = String.valueOf(obj);
        try {
            return this.loader.loadClass(name + ".package-info").getPackage();
        }
        catch (ClassNotFoundException e) {
            try {
                return this.loader.loadClass(name).getPackage();
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private Class loadClass(Object it) {
        if (Class.class.isInstance(it)) {
            return (Class)Class.class.cast(it);
        }
        try {
            return this.loader.loadClass(String.valueOf(it));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

