/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.backbone.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type rawType;
    private final Type[] types;
    private Integer hash;

    public ParameterizedTypeImpl(Type rawType, Type ... types) {
        this.rawType = rawType;
        this.types = types;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.types;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (ParameterizedType.class.isInstance(obj)) {
            ParameterizedType that = (ParameterizedType)ParameterizedType.class.cast(obj);
            Type thatRawType = that.getRawType();
            return Objects.equals(this.rawType, thatRawType) && Arrays.equals(this.types, that.getActualTypeArguments());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Class)Class.class.cast(this.rawType)).getSimpleName());
        Type[] actualTypes = this.getActualTypeArguments();
        if (actualTypes.length > 0) {
            buffer.append("<");
            int length = actualTypes.length;
            for (int i = 0; i < length; ++i) {
                if (Class.class.isInstance(actualTypes[i])) {
                    buffer.append(((Class)Class.class.cast(actualTypes[i])).getSimpleName());
                } else {
                    buffer.append(actualTypes[i].toString());
                }
                if (i == actualTypes.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(">");
        }
        return buffer.toString();
    }
}

