/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.inject.Provider;
import java.lang.reflect.AccessibleObject;
import java.util.List;
import java.util.Map;
import org.apache.webbeans.intercept.AbstractInvocationContext;

public class InterceptorInvocationContext<T>
extends AbstractInvocationContext<T> {
    protected InterceptionType type;
    protected List<Interceptor<?>> interceptors;
    protected Map<Interceptor<?>, ?> instances;
    protected int index;

    public InterceptorInvocationContext(Provider<T> provider, InterceptionType type, List<Interceptor<?>> interceptors, Map<Interceptor<?>, ?> instances, AccessibleObject method, Object[] parameters) {
        super(provider, method, parameters);
        this.type = type;
        this.interceptors = interceptors;
        this.instances = instances;
    }

    @Override
    public Object proceed() throws Exception {
        if (this.index < this.interceptors.size()) {
            Interceptor<?> interceptor;
            if (!(interceptor = this.interceptors.get(this.index++)).intercepts(this.type)) {
                return this.proceed();
            }
            try {
                return interceptor.intercept(this.type, this.instances.get(interceptor), this);
            }
            catch (Exception e) {
                --this.index;
                throw e;
            }
        }
        return super.proceed();
    }
}

