/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import jakarta.enterprise.context.ContextException;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import org.apache.webbeans.annotation.BeforeDestroyedLiteral;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.spi.ContextsService;

public abstract class AbstractContextsService
implements ContextsService {
    protected final WebBeansContext webBeansContext;
    protected boolean supportsConversation;
    protected Boolean fireRequestLifecycleEvents;

    protected AbstractContextsService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.supportsConversation = webBeansContext.getOpenWebBeansConfiguration().supportsConversation();
    }

    @Override
    public void destroy(Object destroyObject) {
    }

    @Override
    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        return null;
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType, boolean createIfNotExists) {
        return this.getCurrentContext(scopeType);
    }

    @Override
    public void init(Object initializeObject) {
    }

    @Override
    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
    }

    @Override
    public void removeThreadLocals() {
    }

    @Override
    public void setSupportConversations(boolean supportConversations) {
        this.supportsConversation = supportConversations;
    }

    public void destroyOutdatedConversations(ConversationContext currentConversationContext) {
        Set<ConversationContext> conversationContexts;
        ConversationManager conversationManager = null;
        Context sessionContext = this.getCurrentContext(SessionScoped.class, false);
        if (sessionContext != null && sessionContext.isActive() && (conversationContexts = (conversationManager = this.webBeansContext.getConversationManager()).getSessionConversations(sessionContext, false)) != null) {
            Iterator<ConversationContext> convIt = conversationContexts.iterator();
            while (convIt.hasNext()) {
                ConversationContext conversationContext = convIt.next();
                ConversationImpl conv = conversationContext.getConversation();
                if (!conversationManager.conversationTimedOut(conv)) continue;
                conversationManager.destroyConversationContext(conversationContext);
                convIt.remove();
            }
        }
        if (currentConversationContext != null) {
            currentConversationContext.getConversation().iDontUseItAnymore();
            if (currentConversationContext.getConversation().isTransient()) {
                conversationManager = conversationManager != null ? conversationManager : this.webBeansContext.getConversationManager();
                conversationManager.destroyConversationContext(currentConversationContext);
            }
        }
    }

    public boolean isSupportsConversation() {
        return this.supportsConversation;
    }

    protected boolean shouldFireRequestLifecycleEvents() {
        if (this.fireRequestLifecycleEvents == null) {
            NotificationManager notificationManager = this.webBeansContext.getNotificationManager();
            this.fireRequestLifecycleEvents = notificationManager.hasContextLifecycleObserver(InitializedLiteral.INSTANCE_REQUEST_SCOPED) || notificationManager.hasContextLifecycleObserver(BeforeDestroyedLiteral.INSTANCE_REQUEST_SCOPED) || notificationManager.hasContextLifecycleObserver(DestroyedLiteral.INSTANCE_REQUEST_SCOPED);
        }
        return this.fireRequestLifecycleEvents;
    }
}

