/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.core.impl;

import io.yupiik.uship.jsonrpc.core.api.JsonRpc;
import io.yupiik.uship.jsonrpc.core.impl.SimpleJsonRpcMethodRegistry;
import io.yupiik.uship.webserver.tomcat.TomcatWebServer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.json.bind.Jsonb;
import jakarta.json.spi.JsonProvider;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.stream.Collectors;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;

@ApplicationScoped
public class JsonRpcMethodRegistry
extends SimpleJsonRpcMethodRegistry {
    @Inject
    private Jsonb jsonb;
    @Inject
    private JsonProvider jsonProvider;
    @Inject
    @JsonRpc
    private Instance<Object> jsonRpcInstances;

    public void doInitAtStartup(@Observes @Initialized(value=ApplicationScoped.class) Object init, Instance<Object> base) {
        super.setJsonb(this.jsonb);
        super.setJsonProvider(this.jsonProvider);
        super.setJsonRpcInstances(this.jsonRpcInstances.stream().collect(Collectors.toList()));
        if (this.getBaseUrl() == null) {
            if (ServletContext.class.isInstance(init)) {
                ServletContext ctx = (ServletContext)ServletContext.class.cast(init);
                super.setBaseUrl("http://" + ctx.getVirtualServerName() + "/jsonrpc");
            } else {
                super.setBaseUrl(LazyBaseUrlFinder.getBaseUrl(base));
            }
        }
        super.init();
    }

    private static class LazyBaseUrlFinder {
        private LazyBaseUrlFinder() {
        }

        private static String getBaseUrl(Instance<Object> instance) {
            Tomcat tomcat = ((TomcatWebServer)TomcatWebServer.class.cast(instance.select(TomcatWebServer.class, new Annotation[0]).get())).getTomcat();
            Connector connector = tomcat.getConnector();
            return connector.getScheme() + "://" + tomcat.getHost().getName() + ":" + ((AbstractProtocol)AbstractProtocol.class.cast(connector.getProtocolHandler())).getLocalPort() + "/jsonrpc";
        }
    }
}

