/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.NotificationOptions;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.util.TypeLiteral;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.util.Asserts;

public class EventImpl<T>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = 393021493190378023L;
    private EventMetadataImpl metadata;
    private transient WebBeansContext webBeansContext;
    private volatile transient ConcurrentMap<ObserverCacheKey, List<ObserverMethod<? super Object>>> observers;
    private volatile transient ConcurrentMap<ObserverCacheKey, List<ObserverMethod<? super Object>>> asyncObservers;
    private volatile transient List<ObserverMethod<? super Object>> defaultMetadataObservers;
    private volatile transient List<ObserverMethod<? super Object>> defaultMetadataAsyncObservers;

    public EventImpl(EventMetadata metadata, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(metadata, "event metadata");
        this.metadata = this.wrapMetadata(metadata);
        this.webBeansContext = webBeansContext;
        this.webBeansContext.getWebBeansUtil().validEventType(metadata.getType(), metadata.getType());
        if (webBeansContext.getWebBeansUtil().isContainerEventType(this.metadata.validatedType())) {
            throw new IllegalArgumentException("Firing container events is forbidden");
        }
    }

    private EventMetadataImpl wrapMetadata(EventMetadata metadata) {
        if (metadata instanceof EventMetadataImpl) {
            return (EventMetadataImpl)metadata;
        }
        Set<Annotation> qualifiers = metadata.getQualifiers();
        return new EventMetadataImpl(null, metadata.getType(), metadata.getInjectionPoint(), qualifiers.toArray(new Annotation[qualifiers.size()]), this.webBeansContext);
    }

    @Override
    public void fire(T event) {
        Class<?> eventType = event.getClass();
        if (this.metadata.validatedType() == eventType) {
            this.doFireSyncEvent(event, this.metadata);
        } else {
            this.webBeansContext.getWebBeansUtil().validEventType(eventType.getClass(), this.metadata.getType());
            this.doFireSyncEvent(event, this.metadata.select(eventType, new Annotation[0]));
        }
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(U event) {
        return this.fireAsync(event, this.webBeansContext.getNotificationManager().getDefaultNotificationOptions());
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(U event, NotificationOptions notificationOptions) {
        Class<?> eventType = event.getClass();
        if (eventType != this.metadata.validatedType()) {
            this.webBeansContext.getWebBeansUtil().validEventType(eventType.getClass(), this.metadata.getType());
            return this.webBeansContext.getNotificationManager().fireEvent(event, this.metadata.select(eventType, new Annotation[0]), false, notificationOptions);
        }
        return this.doFireAsyncEvent(event, this.metadata, notificationOptions);
    }

    @Override
    public Event<T> select(Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(bindings), this.webBeansContext);
    }

    @Override
    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(subtype, bindings), this.webBeansContext);
    }

    @Override
    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(subtype, bindings), this.webBeansContext);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
    }

    public EventMetadataImpl getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFireSyncEvent(T event, EventMetadataImpl metadata) {
        ArrayList<ObserverMethod<? super Object>> observerMethods;
        NotificationManager notificationManager = this.webBeansContext.getNotificationManager();
        if (metadata == this.metadata) {
            if (this.defaultMetadataObservers == null) {
                ArrayList<ObserverMethod<? super Object>> tmp = new ArrayList<ObserverMethod<? super Object>>(notificationManager.resolveObservers(event, metadata, false));
                notificationManager.prepareObserverListForFire(false, false, tmp);
                this.defaultMetadataObservers = tmp;
            }
            observerMethods = this.defaultMetadataObservers;
        } else {
            ObserverCacheKey key;
            if (this.webBeansContext.getWebBeansUtil().isContainerEventType(event)) {
                throw new IllegalArgumentException("Firing container events is forbidden");
            }
            if (this.observers == null) {
                EventImpl tmp = this;
                synchronized (tmp) {
                    if (this.observers == null) {
                        this.observers = new ConcurrentHashMap<ObserverCacheKey, List<ObserverMethod<? super Object>>>();
                    }
                }
            }
            if ((observerMethods = (ArrayList<ObserverMethod<? super Object>>)this.observers.get(key = new ObserverCacheKey(event.getClass(), metadata.validatedType(), metadata.getQualifiers()))) == null) {
                observerMethods = new ArrayList<ObserverMethod<? super Object>>(notificationManager.resolveObservers(event, metadata, false));
                notificationManager.prepareObserverListForFire(false, false, observerMethods);
                this.observers.putIfAbsent(key, observerMethods);
            }
        }
        notificationManager.doFireSync(new EventContextImpl<T>(event, metadata), false, observerMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U extends T> CompletionStage<U> doFireAsyncEvent(T event, EventMetadataImpl metadata, NotificationOptions options) {
        ArrayList<ObserverMethod<? super Object>> observerMethods;
        NotificationManager notificationManager = this.webBeansContext.getNotificationManager();
        if (metadata == this.metadata) {
            if (this.defaultMetadataAsyncObservers == null) {
                ArrayList<ObserverMethod<? super Object>> tmp = new ArrayList<ObserverMethod<? super Object>>(notificationManager.resolveObservers(event, metadata, false));
                notificationManager.prepareObserverListForFire(false, true, tmp);
                this.defaultMetadataAsyncObservers = tmp;
            }
            observerMethods = this.defaultMetadataAsyncObservers;
        } else {
            ObserverCacheKey key;
            if (this.webBeansContext.getWebBeansUtil().isContainerEventType(event)) {
                throw new IllegalArgumentException("Firing container events is forbidden");
            }
            if (this.asyncObservers == null) {
                EventImpl tmp = this;
                synchronized (tmp) {
                    if (this.asyncObservers == null) {
                        this.asyncObservers = new ConcurrentHashMap<ObserverCacheKey, List<ObserverMethod<? super Object>>>();
                    }
                }
            }
            if ((observerMethods = (ArrayList<ObserverMethod<? super Object>>)this.asyncObservers.get(key = new ObserverCacheKey(event.getClass(), metadata.validatedType(), metadata.getQualifiers()))) == null) {
                observerMethods = new ArrayList<ObserverMethod<? super Object>>(notificationManager.resolveObservers(event, metadata, false));
                notificationManager.prepareObserverListForFire(false, true, observerMethods);
                this.asyncObservers.putIfAbsent(key, observerMethods);
            }
        }
        return notificationManager.doFireAsync(new EventContextImpl<T>(event, metadata), false, options, observerMethods);
    }

    private static class ObserverCacheKey {
        private final Class<?> clazz;
        private final Type type;
        private final Collection<Annotation> qualifiers;
        private final int hash;

        private ObserverCacheKey(Class<?> clazz, Type type, Collection<Annotation> qualifiers) {
            this.clazz = clazz;
            this.type = type;
            this.qualifiers = qualifiers;
            this.hash = Objects.hash(clazz, type, qualifiers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObserverCacheKey that = (ObserverCacheKey)ObserverCacheKey.class.cast(o);
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.type, that.type) && Objects.equals(this.qualifiers, that.qualifiers);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

