/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.se;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.spi.BDABeansXmlScanner;

public class DefaultBDABeansXmlScanner
implements BDABeansXmlScanner {
    private Map<Class<?>, String> jarBeanClasses;
    private final Map<String, Set<Class<?>>> interceptorsPerBDA = new HashMap();
    private final Map<String, Set<Class<?>>> decoratorsPerBDA = new HashMap();
    private final Map<String, Set<Class<?>>> alternativesPerBDA;
    private final Map<String, Set<Class<? extends Annotation>>> stereotypesPerBDA = new HashMap<String, Set<Class<? extends Annotation>>>();

    public DefaultBDABeansXmlScanner() {
        this.alternativesPerBDA = new HashMap();
        this.jarBeanClasses = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptor(Class<?> interceptorClass, String beansXMLFilePath) {
        if (interceptorClass == null || beansXMLFilePath == null) {
            return false;
        }
        Map<String, Set<Class<?>>> map = this.interceptorsPerBDA;
        synchronized (map) {
            Set interceptorClasses = this.interceptorsPerBDA.computeIfAbsent(beansXMLFilePath, k -> new HashSet());
            return interceptorClasses.add(interceptorClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<?>> getInterceptors(String beansXMLFilePath) {
        Map<String, Set<Class<?>>> map = this.interceptorsPerBDA;
        synchronized (map) {
            Set<Class<?>> set = this.interceptorsPerBDA.get(beansXMLFilePath);
            if (set != null) {
                return new HashSet(set);
            }
            return new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<?>> getDecorators(String beansXMLFilePath) {
        Map<String, Set<Class<?>>> map = this.decoratorsPerBDA;
        synchronized (map) {
            Set<Class<?>> set = this.decoratorsPerBDA.get(beansXMLFilePath);
            if (set != null) {
                return new HashSet(set);
            }
            return new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDecorator(Class<?> decoratorClass, String beansXMLFilePath) {
        if (decoratorClass == null || beansXMLFilePath == null) {
            return false;
        }
        Map<String, Set<Class<?>>> map = this.decoratorsPerBDA;
        synchronized (map) {
            Set decoratorClasses = this.decoratorsPerBDA.computeIfAbsent(beansXMLFilePath, k -> new HashSet());
            return decoratorClasses.add(decoratorClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAlternative(Class<?> alternativeClass, String beansXMLFilePath) {
        if (alternativeClass == null || beansXMLFilePath == null) {
            return false;
        }
        Map<String, Set<Class<?>>> map = this.alternativesPerBDA;
        synchronized (map) {
            Set alternativeClasses = this.alternativesPerBDA.computeIfAbsent(beansXMLFilePath, k -> new HashSet());
            return alternativeClasses.add(alternativeClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addStereoType(Class<? extends Annotation> stereoTypeClass, String beansXMLFilePath) {
        if (stereoTypeClass == null || beansXMLFilePath == null) {
            return false;
        }
        Map<String, Set<Class<? extends Annotation>>> map = this.stereotypesPerBDA;
        synchronized (map) {
            Set stereoTypeClasses = this.stereotypesPerBDA.computeIfAbsent(beansXMLFilePath, k -> new HashSet());
            return stereoTypeClasses.add(stereoTypeClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<?>> getAlternatives(String beansXMLFilePath) {
        Map<String, Set<Class<?>>> map = this.alternativesPerBDA;
        synchronized (map) {
            Set<Class<?>> set = this.alternativesPerBDA.get(beansXMLFilePath);
            if (set != null) {
                return new HashSet(set);
            }
            return new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<? extends Annotation>> getStereotypes(String beansXMLFilePath) {
        Map<String, Set<Class<? extends Annotation>>> map = this.stereotypesPerBDA;
        synchronized (map) {
            Set<Class<? extends Annotation>> set = this.stereotypesPerBDA.get(beansXMLFilePath);
            if (set != null) {
                return new HashSet<Class<? extends Annotation>>(set);
            }
            return new HashSet<Class<? extends Annotation>>();
        }
    }

    @Override
    public String getBeansXml(Class<?> class1) {
        return this.jarBeanClasses.get(class1);
    }

    @Override
    public void setBeansXml(Class<?> class1, String beansXmlFilePath) {
        this.jarBeanClasses.put(class1, beansXmlFilePath);
    }
}

