/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc.openapi;

import io.yupiik.uship.jsonrpc.core.openrpc.OpenRPC;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class OpenRPC2OpenAPI
implements Function<Configuration, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;
    private final Jsonb jsonb;

    public OpenRPC2OpenAPI(JsonBuilderFactory jsonBuilderFactory, Jsonb jsonb) {
        this.jsonBuilderFactory = jsonBuilderFactory;
        this.jsonb = jsonb;
    }

    @Override
    public JsonObject apply(Configuration configuration) {
        OpenRPC openRpc = configuration.getOpenRPCLoader().apply(this.jsonb);
        TreeSet<String> tags = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        return this.jsonBuilderFactory.createObjectBuilder().add("openapi", configuration.getOpenapiVersion()).add("servers", this.createServers(configuration, openRpc)).add("info", this.createInfo(configuration)).add("paths", this.createPaths(configuration, openRpc, tags)).add("tags", this.createTags(tags)).add("components", this.createComponents(openRpc)).build();
    }

    protected JsonObjectBuilder createPaths(Configuration configuration, OpenRPC openRpc, Set<String> tags) {
        JsonObject voidSchema = this.jsonBuilderFactory.createObjectBuilder().add("type", "object").build();
        return openRpc.getMethods().stream().collect(Collector.of(this.jsonBuilderFactory::createObjectBuilder, (a, i) -> {
            try {
                this.addMethod(configuration, tags, voidSchema, (JsonObjectBuilder)a, (OpenRPC.RpcMethod)i);
            }
            catch (RuntimeException re) {
                throw new IllegalStateException(re.getMessage() + " for: " + i, re);
            }
        }, JsonObjectBuilder::addAll, new Collector.Characteristics[0]));
    }

    protected void addMethod(Configuration configuration, Set<String> tags, JsonObject voidSchema, JsonObjectBuilder objectBuilder, OpenRPC.RpcMethod method) {
        JsonArray tagValues = configuration.getTagProvider() != null ? configuration.getTagProvider().apply(method.getName()) : JsonValue.EMPTY_JSON_ARRAY;
        tagValues.stream().map(JsonString.class::cast).map(JsonString::getString).forEach(tags::add);
        JsonObjectBuilder base = this.jsonBuilderFactory.createObjectBuilder().add("operationId", method.getName()).add("summary", method.getDescription()).add("requestBody", this.createRequestBody(configuration, method)).add("responses", this.createResponses(configuration, voidSchema, method));
        if (!tagValues.isEmpty()) {
            base.add("tags", tagValues);
        }
        objectBuilder.add(this.toMethodPath(method), this.jsonBuilderFactory.createObjectBuilder().add("post", base));
    }

    protected String toMethodPath(OpenRPC.RpcMethod method) {
        return "/" + method.getName();
    }

    protected JsonObjectBuilder createRequestBody(Configuration configuration, OpenRPC.RpcMethod method) {
        JsonObject params = this.toJsonSchema(method.getParams()).build();
        return this.jsonBuilderFactory.createObjectBuilder().add("content", this.jsonBuilderFactory.createObjectBuilder().add("application/json", this.jsonBuilderFactory.createObjectBuilder().add("schema", configuration.isWrapPayload() ? this.wrapParams(params, method) : params)));
    }

    protected JsonObject wrapParams(JsonObject params, OpenRPC.RpcMethod method) {
        return this.jsonBuilderFactory.createObjectBuilder().add("type", "object").add("properties", this.jsonBuilderFactory.createObjectBuilder().add("jsonrpc", this.jsonBuilderFactory.createObjectBuilder().add("type", "string").add("default", "2.0").add("description", "JSON-RPC version, should always be '2.0'.")).add("method", this.jsonBuilderFactory.createObjectBuilder().add("type", "string").add("default", method.getName()).add("description", "The JSON-RPC method name, should always be '" + method.getName() + "'")).add("params", params)).add("required", this.jsonBuilderFactory.createArrayBuilder().add("jsonrpc").add("method")).build();
    }

    protected JsonObjectBuilder createResponses(Configuration configuration, JsonObject voidSchema, OpenRPC.RpcMethod method) {
        JsonObject resultSchema = method.getResult() == null ? voidSchema : this.stripId(this.toJsonObject(method.getResult().getSchema()));
        JsonObjectBuilder ok = this.create200Response(configuration, resultSchema);
        JsonObjectBuilder base = this.jsonBuilderFactory.createObjectBuilder().add("200", ok);
        Collection<OpenRPC.ErrorValue> errors = method.getErrors();
        if (errors == null || errors.isEmpty()) {
            return base;
        }
        AtomicInteger counter = new AtomicInteger();
        errors.forEach(it -> base.add(this.toErrorName((OpenRPC.ErrorValue)it, counter.incrementAndGet()), this.createErrorResponse(configuration, (OpenRPC.ErrorValue)it)));
        return base;
    }

    protected String toErrorName(OpenRPC.ErrorValue error, int counter) {
        return error.getCode() >= 100 && error.getCode() <= 999 ? String.valueOf(error.getCode()) : String.format("5%02d", error.getCode() < 100 ? error.getCode() : counter);
    }

    protected JsonObjectBuilder createErrorResponse(Configuration configuration, OpenRPC.ErrorValue error) {
        JsonObject schema = error.getData() == null ? this.jsonBuilderFactory.createObjectBuilder().add("type", "object").build() : this.stripId(this.toJsonObject(error.getData()));
        String errorCode = "Error code=" + error.getCode();
        return this.jsonBuilderFactory.createObjectBuilder().add("description", Optional.ofNullable(error.getMessage()).map(it -> it + " (" + errorCode + ")").orElse(errorCode)).add("content", this.jsonBuilderFactory.createObjectBuilder().add("application/json", this.jsonBuilderFactory.createObjectBuilder().add("schema", configuration.isWrapPayload() ? this.wrapResult(schema) : schema)));
    }

    protected JsonObjectBuilder create200Response(Configuration configuration, JsonObject resultSchema) {
        return this.jsonBuilderFactory.createObjectBuilder().add("description", "OK").add("content", this.jsonBuilderFactory.createObjectBuilder().add("application/json", this.jsonBuilderFactory.createObjectBuilder().add("schema", configuration.isWrapPayload() ? this.wrapResult(resultSchema) : resultSchema)));
    }

    protected JsonObject wrapError(JsonObject schema) {
        return this.jsonBuilderFactory.createObjectBuilder().add("type", "object").add("properties", this.jsonBuilderFactory.createObjectBuilder().add("jsonrpc", this.jsonBuilderFactory.createObjectBuilder().add("type", "string").add("default", "2.0").add("description", "JSON-RPC version, should always be '2.0'.")).add("error", schema)).add("required", this.jsonBuilderFactory.createArrayBuilder().add("jsonrpc").add("error")).build();
    }

    protected JsonObject wrapResult(JsonObject params) {
        return this.jsonBuilderFactory.createObjectBuilder().add("type", "object").add("properties", this.jsonBuilderFactory.createObjectBuilder().add("jsonrpc", this.jsonBuilderFactory.createObjectBuilder().add("type", "string").add("default", "2.0").add("description", "JSON-RPC version, should always be '2.0'.")).add("result", params)).add("required", this.jsonBuilderFactory.createArrayBuilder().add("jsonrpc").add("result")).build();
    }

    protected JsonArrayBuilder createTags(Set<String> tags) {
        return tags.stream().collect(Collector.of(this.jsonBuilderFactory::createArrayBuilder, (b, n) -> b.add(this.jsonBuilderFactory.createObjectBuilder().add("name", (String)n).add("description", (String)n)), JsonArrayBuilder::addAll, new Collector.Characteristics[0]));
    }

    protected JsonObjectBuilder createComponents(OpenRPC openRpc) {
        return this.jsonBuilderFactory.createObjectBuilder().add("schemas", this.createSchemas(openRpc));
    }

    protected JsonObjectBuilder createSchemas(OpenRPC openRpc) {
        return this.jsonBuilderFactory.createObjectBuilder(openRpc.getComponents().getSchemas().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.stripId(this.toJsonObject(e.getValue())))));
    }

    protected JsonArray createServers(Configuration configuration, OpenRPC openRpc) {
        return configuration.getServers() == null ? openRpc.getServers().stream().map(s -> this.jsonBuilderFactory.createObjectBuilder().add("url", s.getUrl()).add("description", Optional.ofNullable(s.getSummary()).orElse(""))).collect(Collector.of(this.jsonBuilderFactory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0])) : configuration.getServers();
    }

    protected JsonObjectBuilder createInfo(Configuration configuration) {
        return this.jsonBuilderFactory.createObjectBuilder().add("title", configuration.getTitle()).add("description", configuration.getDescription()).add("version", configuration.getVersion());
    }

    protected JsonObject toJsonObject(Object data) {
        return this.jsonb.fromJson(this.jsonb.toJson(data), JsonObject.class);
    }

    protected JsonObject stripId(JsonObject jsonObject) {
        return this.jsonBuilderFactory.createObjectBuilder(jsonObject.entrySet().stream().filter(it -> !"$id".equals(it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            switch (((JsonValue)entry.getValue()).getValueType()) {
                case ARRAY: {
                    return this.jsonBuilderFactory.createArrayBuilder(((JsonValue)entry.getValue()).asJsonArray().stream().map(i -> i.getValueType() == JsonValue.ValueType.OBJECT ? this.stripId(i.asJsonObject()) : i).collect(Collectors.toList())).build();
                }
                case OBJECT: {
                    return this.stripId(((JsonValue)entry.getValue()).asJsonObject());
                }
            }
            return entry.getValue();
        }))).build();
    }

    protected JsonObjectBuilder toJsonSchema(Collection<OpenRPC.Value> params) {
        ArrayList required = new ArrayList();
        JsonObjectBuilder base = this.jsonBuilderFactory.createObjectBuilder().add("type", "object").add("properties", params.stream().peek(it -> {
            if (it.getRequired() != null && it.getRequired().booleanValue()) {
                required.add(it.getName());
            }
        }).collect(Collector.of(this.jsonBuilderFactory::createObjectBuilder, (a, i) -> a.add(i.getName(), this.stripId(this.toJsonObject(i.getSchema()))), JsonObjectBuilder::addAll, new Collector.Characteristics[0])));
        if (required.isEmpty()) {
            return base;
        }
        return base.add("required", required.stream().collect(Collector.of(this.jsonBuilderFactory::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::addAll, new Collector.Characteristics[0])));
    }

    public static class Configuration {
        private Function<Jsonb, OpenRPC> openRPCLoader;
        private Function<String, JsonArray> tagProvider;
        private String openapiVersion = "3.0.3";
        private String title;
        private String description;
        private String version;
        private JsonArray servers;
        private boolean wrapPayload = true;

        public Function<String, JsonArray> getTagProvider() {
            return this.tagProvider;
        }

        public Configuration setTagProvider(Function<String, JsonArray> tagProvider) {
            this.tagProvider = tagProvider;
            return this;
        }

        public boolean isWrapPayload() {
            return this.wrapPayload;
        }

        public Configuration setWrapPayload(boolean wrapPayload) {
            this.wrapPayload = wrapPayload;
            return this;
        }

        public String getOpenapiVersion() {
            return this.openapiVersion;
        }

        public Configuration setOpenapiVersion(String openapiVersion) {
            this.openapiVersion = openapiVersion;
            return this;
        }

        public Function<Jsonb, OpenRPC> getOpenRPCLoader() {
            return this.openRPCLoader;
        }

        public Configuration setOpenRPC(OpenRPC openRPC) {
            this.openRPCLoader = j -> openRPC;
            return this;
        }

        public Configuration setOpenRPCLoader(Function<Jsonb, OpenRPC> openRPCLoader) {
            this.openRPCLoader = openRPCLoader;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Configuration setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Configuration setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Configuration setVersion(String version) {
            this.version = version;
            return this;
        }

        public JsonArray getServers() {
            return this.servers;
        }

        public Configuration setServers(JsonArray servers) {
            this.servers = servers;
            return this;
        }
    }
}

