/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.doc;

import io.yupiik.uship.backbone.johnzon.jsonschema.Schema;
import io.yupiik.uship.jsonrpc.core.openrpc.OpenRPC;
import io.yupiik.uship.jsonrpc.doc.CliSibling;
import io.yupiik.uship.jsonrpc.doc.postman.PostmanCollection;
import jakarta.json.Json;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PostmanCollectionGenerator
implements Runnable {
    private final JsonGeneratorFactory jsonGeneratorFactory;
    private final Jsonb jsonb;
    private final OpenRPC openrpc;
    private final PrintStream output;

    public PostmanCollectionGenerator(Reader openrpc, PrintStream output, Jsonb jsonb, JsonGeneratorFactory jsonGeneratorFactory) {
        this.jsonb = jsonb;
        this.jsonGeneratorFactory = jsonGeneratorFactory;
        this.openrpc = jsonb.fromJson(openrpc, OpenRPC.class);
        this.output = output;
    }

    @Override
    public void run() {
        List<PostmanCollection.Item> items = Optional.ofNullable(this.openrpc.getMethods()).orElseGet(List::of).stream().map(this::toPostman).collect(Collectors.toList());
        PostmanCollection.Info info = new PostmanCollection.Info();
        if (this.openrpc.getInfo() != null) {
            info.setName(this.openrpc.getInfo().getTitle());
            info.setVersion(this.openrpc.getInfo().getVersion());
        }
        PostmanCollection.Variable endpointVariable = new PostmanCollection.Variable();
        endpointVariable.setKey("JSON_RPC_ENDPOINT");
        endpointVariable.setValue(Optional.ofNullable(this.openrpc.getServers()).orElseGet(List::of).stream().map(OpenRPC.Server::getUrl).findFirst().orElse("http://localhost:8080/jsonrpc"));
        PostmanCollection root = new PostmanCollection();
        root.setInfo(info);
        root.setItems(items);
        root.setVariable(List.of(endpointVariable));
        this.jsonb.toJson((Object)root, this.output);
    }

    private PostmanCollection.Item toPostman(OpenRPC.RpcMethod registration) {
        PostmanCollection.Header jsonAcceptHeader = new PostmanCollection.Header();
        jsonAcceptHeader.setKey("Accept");
        PostmanCollection.Header jsonContentTypeHeader = new PostmanCollection.Header();
        jsonContentTypeHeader.setKey("Content-Type");
        Stream.of(jsonAcceptHeader, jsonContentTypeHeader).forEach(h -> {
            h.setValue("application/json");
            h.setType("text");
        });
        PostmanCollection.Body body = new PostmanCollection.Body();
        body.setMode("raw");
        body.setRaw(this.toSampleRequest(registration.getName(), registration.getParams()));
        PostmanCollection.Request request = new PostmanCollection.Request();
        request.setMethod("POST");
        request.setUrl("{{JSON_RPC_ENDPOINT}}");
        request.setHeader(List.of(jsonAcceptHeader, jsonContentTypeHeader));
        request.setBody(body);
        PostmanCollection.Item item = new PostmanCollection.Item();
        item.setName(registration.getName());
        item.setRequest(request);
        item.setResponse(List.of());
        return item;
    }

    private String toSampleRequest(String jsonRpcMethod, Collection<OpenRPC.Value> parameters) {
        StringWriter out = new StringWriter();
        try (JsonGenerator gen = this.jsonGeneratorFactory.createGenerator(out);){
            gen.writeStartObject();
            gen.write("jsonrpc", "2.0");
            gen.write("method", jsonRpcMethod);
            if (!parameters.isEmpty()) {
                gen.writeStartObject("params");
                parameters.forEach(p -> this.toSampleParam(p.getName(), p.getSchema(), gen));
                gen.writeEnd();
            }
            gen.writeEnd();
        }
        return out.toString();
    }

    private void toSampleParam(String name, Schema schema, JsonGenerator generator) {
        if (schema == null) {
            return;
        }
        switch (schema.getType()) {
            case string: {
                generator.write(name, schema.getExample() != null ? schema.getExample().toString() : "string");
                break;
            }
            case number: 
            case integer: {
                generator.write(name, schema.getExample() != null ? ((Number)Number.class.cast(schema.getExample())).doubleValue() : 123.0);
                break;
            }
            case bool: {
                generator.write(name, schema.getExample() != null ? (Boolean)Boolean.class.cast(schema.getExample()) : true);
                break;
            }
            case array: {
                generator.writeStartArray(name);
                Schema items = schema.getItems();
                if (items != null) {
                    switch (items.getType()) {
                        case string: {
                            generator.write(items.getExample() != null ? items.getExample().toString() : "string");
                            break;
                        }
                        case number: 
                        case integer: {
                            generator.write(items.getExample() != null ? ((Number)Number.class.cast(items.getExample())).doubleValue() : 123.0);
                            break;
                        }
                        case bool: {
                            generator.write(items.getExample() != null ? (Boolean)Boolean.class.cast(items.getExample()) : true);
                            break;
                        }
                        case array: {
                            generator.writeStartArray(name);
                            generator.writeEnd();
                            break;
                        }
                        case object: {
                            generator.writeStartObject();
                            if (items.getProperties() != null) {
                                items.getProperties().forEach((n, s) -> this.toSampleParam((String)n, (Schema)s, generator));
                            }
                            generator.writeEnd();
                            break;
                        }
                    }
                }
                generator.writeEnd();
                break;
            }
            case object: {
                generator.writeStartObject(name);
                if (schema.getProperties() != null) {
                    schema.getProperties().forEach((n, s) -> this.toSampleParam((String)n, (Schema)s, generator));
                }
                generator.writeEnd();
                break;
            }
        }
    }

    public static void main(String ... args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: java -cp ... " + PostmanCollectionGenerator.class.getName() + " <openrpc path or stdin> <output>");
        }
        try (Reader input = CliSibling.toReader(args[0]);
             PrintStream output = CliSibling.toOutputStream(args[1]);
             Jsonb jsonb = JsonbBuilder.create(new JsonbConfig().withFormatting(true));){
            new PostmanCollectionGenerator(input, output, jsonb, Json.createGeneratorFactory(Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true))).run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

