/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.core.servlet;

import io.yupiik.uship.jsonrpc.core.impl.SimpleJsonRpcHandler;
import io.yupiik.uship.jsonrpc.core.protocol.JsonRpcException;
import io.yupiik.uship.jsonrpc.core.servlet.JsonRpcBeforeExecution;
import jakarta.json.JsonException;
import jakarta.json.JsonStructure;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleJsonRpcServlet
extends HttpServlet {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private SimpleJsonRpcHandler handler;
    private Consumer<JsonRpcBeforeExecution> beforeExecutionEvent;
    private Jsonb jsonb;

    protected void setHandler(SimpleJsonRpcHandler handler) {
        this.handler = handler;
    }

    protected void setBeforeExecutionEvent(Consumer<JsonRpcBeforeExecution> beforeExecutionEvent) {
        this.beforeExecutionEvent = beforeExecutionEvent;
    }

    protected void setJsonb(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonStructure request;
        try {
            request = this.handler.readRequest(req, req.getReader());
        }
        catch (JsonException | JsonbException jsonbEx) {
            this.forwardResponse(this.handler.createResponse(null, -32700, jsonbEx.getMessage()), resp);
            return;
        }
        try {
            this.beforeExecutionEvent.accept(new JsonRpcBeforeExecution(request, req));
        }
        catch (JsonRpcException re) {
            this.forwardResponse(this.handler.toErrorResponse(null, re, request), resp);
            return;
        }
        catch (RuntimeException re) {
            this.forwardResponse(this.handler.createResponse(null, 100, re.getMessage()), resp);
            return;
        }
        AsyncContext ctx = req.startAsync();
        this.handler.execute(request, req, resp).whenComplete((value, error) -> {
            try {
                if (value != null) {
                    this.forwardResponse(value, resp);
                } else {
                    this.forwardResponse(this.handler.createResponse(null, -32603, error.getMessage()), resp);
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new IllegalStateException(e);
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                ctx.complete();
            }
        });
    }

    private void forwardResponse(Object payload, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.addHeader("content-type", "application/json;charset=utf-8");
        try (PrintWriter out = resp.getWriter();){
            this.jsonb.toJson(payload, out);
        }
    }
}

