/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.jsonrpc.core.api.service;

import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleJsonRpcExtractor {
    public List<String> findJsonRpcMethods(JsonStructure request) {
        return this.findJsonRpcMethods(request, obj -> Stream.of(obj.asJsonObject().getString("method")));
    }

    public List<String> findJsonRpcMethods(JsonStructure request, Function<JsonObject, Stream<String>> recursiveExtractor) {
        switch (request.getValueType()) {
            case OBJECT: {
                return recursiveExtractor.apply(request.asJsonObject()).collect(Collectors.toList());
            }
            case ARRAY: {
                return request.asJsonArray().stream().flatMap(it -> this.findJsonRpcMethods(it.asJsonObject(), recursiveExtractor).stream()).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException("Invalid parameter: " + request.getValueType());
    }
}

