/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.inject.spi.configurator.ProducerConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.ProducerConfiguratorImpl;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessProducerImpl<X, T>
extends EventBase
implements ProcessProducer<X, T> {
    private final AnnotatedMember<X> annotateMember;
    private Producer<T> producer;
    private ProducerConfiguratorImpl<T> producerConfigurator;
    private boolean customProducerSet;

    public ProcessProducerImpl(Producer<T> producer, AnnotatedMember<X> annotateMember) {
        this.annotateMember = annotateMember;
        this.producer = producer;
    }

    @Override
    public void addDefinitionError(Throwable t) {
        this.checkState();
        WebBeansContext.getInstance().getBeanManagerImpl().getErrorStack().pushError(t);
    }

    @Override
    public ProducerConfigurator<T> configureProducer() {
        this.checkState();
        if (this.customProducerSet) {
            throw new IllegalStateException("Only one of setProducer() and configureProducer() must be used!");
        }
        this.producerConfigurator = new ProducerConfiguratorImpl();
        this.producer = null;
        return this.producerConfigurator;
    }

    @Override
    public AnnotatedMember<X> getAnnotatedMember() {
        this.checkState();
        return this.annotateMember;
    }

    @Override
    public Producer<T> getProducer() {
        this.checkState();
        if (this.producerConfigurator != null) {
            return this.producerConfigurator.getProducer();
        }
        return this.producer;
    }

    @Override
    public void setProducer(Producer<T> producer) {
        this.checkState();
        if (this.producerConfigurator != null) {
            throw new IllegalStateException("Only one of setProducer() and configureProducer() must be used!");
        }
        this.producer = producer;
        this.customProducerSet = true;
    }
}

