/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.openwebbeans.se.OWBInitializer;
import org.apache.openwebbeans.se.SeContainerSelector;
import org.apache.webbeans.conversation.DefaultConversationService;
import org.apache.webbeans.corespi.se.StandaloneContextsService;
import org.apache.webbeans.lifecycle.StandaloneLifeCycle;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;

public class SeInitializerFacade
extends SeContainerInitializer {
    public static final String PROVIDER = SeContainerInitializer.class.getName() + ".provider";
    private final Collection<Consumer<SeContainerInitializer>> initializers = new ArrayList<Consumer<SeContainerInitializer>>();
    private SeContainerInitializer delegate;

    @Override
    public SeContainerInitializer addBeanClasses(Class<?> ... classes) {
        this.initializers.add(i -> i.addBeanClasses(classes));
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(Class<?> ... packageClasses) {
        this.initializers.add(i -> i.addPackages(packageClasses));
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(boolean scanRecursively, Class<?> ... packageClasses) {
        this.initializers.add(i -> i.addPackages(scanRecursively, packageClasses));
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(Package ... packages) {
        this.initializers.add(i -> i.addPackages(packages));
        return this;
    }

    @Override
    public SeContainerInitializer addPackages(boolean scanRecursively, Package ... packages) {
        this.initializers.add(i -> i.addPackages(scanRecursively, packages));
        return this;
    }

    @Override
    public SeContainerInitializer addExtensions(Extension ... extensions) {
        this.initializers.add(i -> i.addExtensions(extensions));
        return this;
    }

    @Override
    public SeContainerInitializer addExtensions(Class<? extends Extension> ... extensions) {
        this.initializers.add(i -> i.addExtensions(extensions));
        return this;
    }

    @Override
    public SeContainerInitializer enableInterceptors(Class<?> ... interceptorClasses) {
        this.initializers.add(i -> i.enableInterceptors(interceptorClasses));
        return this;
    }

    @Override
    public SeContainerInitializer enableDecorators(Class<?> ... decoratorClasses) {
        this.initializers.add(i -> i.enableDecorators(decoratorClasses));
        return this;
    }

    @Override
    public SeContainerInitializer selectAlternatives(Class<?> ... alternativeClasses) {
        this.initializers.add(i -> i.selectAlternatives(alternativeClasses));
        return this;
    }

    @Override
    public SeContainerInitializer selectAlternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        this.initializers.add(i -> i.selectAlternativeStereotypes(alternativeStereotypeClasses));
        return this;
    }

    @Override
    public SeContainerInitializer addProperty(String key, Object value) {
        if (PROVIDER.endsWith(key)) {
            this.delegate = this.loadProvider(value);
        }
        this.initializers.add(i -> i.addProperty(key, value));
        return this;
    }

    @Override
    public SeContainerInitializer setProperties(Map<String, Object> properties) {
        if (properties != null && properties.containsKey(PROVIDER)) {
            this.addProperty(PROVIDER, properties.get(PROVIDER));
        }
        this.initializers.add(i -> i.setProperties(properties));
        return this;
    }

    @Override
    public SeContainerInitializer disableDiscovery() {
        this.initializers.add(SeContainerInitializer::disableDiscovery);
        return this;
    }

    @Override
    public SeContainerInitializer setClassLoader(ClassLoader classLoader) {
        this.initializers.add(i -> i.setClassLoader(classLoader));
        return this;
    }

    @Override
    public SeContainer initialize() {
        SeContainerInitializer initializer = this.delegate != null ? this.delegate : StreamSupport.stream(ServiceLoader.load(SeContainerSelector.class).spliterator(), false).min(Comparator.comparing(it -> Optional.ofNullable(it.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(0))).map(SeContainerSelector::find).orElseGet(OWBInitializer::new);
        this.initializers.forEach(i -> i.accept(initializer));
        return initializer.initialize();
    }

    private SeContainerInitializer loadProvider(Object value) {
        if (SeContainerInitializer.class.isInstance(value)) {
            return (SeContainerInitializer)SeContainerInitializer.class.cast(value);
        }
        if (Class.class.isInstance(value)) {
            return this.newInitializerInstance(((Class)Class.class.cast(value)).asSubclass(SeContainerInitializer.class));
        }
        return this.newInitializerInstance(this.findClass(String.valueOf(value)));
    }

    private Class<? extends SeContainerInitializer> findClass(String name) {
        switch (name) {
            case "owb": 
            case "openwebbeans": 
            case "org.apache.openwebbeans.se.OWBInitializer": {
                return OWBInitializer.class;
            }
        }
        try {
            return Optional.ofNullable(SeInitializerFacade.class.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass(name.trim()).asSubclass(SeContainerInitializer.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private SeContainerInitializer newInitializerInstance(Class<? extends SeContainerInitializer> type) {
        if (type == OWBInitializer.class) {
            OWBInitializer initializer = new OWBInitializer();
            initializer.addProperty(ContainerLifecycle.class.getName(), StandaloneLifeCycle.class.getName());
            initializer.addProperty(ContextsService.class.getName(), StandaloneContextsService.class.getName());
            initializer.addProperty(ConversationService.class.getName(), DefaultConversationService.class.getName());
            return initializer;
        }
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException());
        }
    }
}

