/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openwebbeans.se.CDISeScannerService;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;

public class PreScannedCDISeScannerService
extends CDISeScannerService {
    @Override
    protected void configure() {
    }

    @Override
    protected void registerBeanArchives(ClassLoader loader) {
    }

    @Override
    protected AnnotationFinder initFinder() {
        if (this.finder != null) {
            return this.finder;
        }
        WebBeansContext webBeansContext = this.webBeansContext();
        OpenWebBeansConfiguration conf = webBeansContext.getOpenWebBeansConfiguration();
        String confKeyBase = this.getClass().getName() + ".";
        String classes = conf.getProperty(confKeyBase + "classes");
        ClassLoader loader = WebBeansUtil.getCurrentClassLoader();
        Class[] reflectClasses = (Class[])Stream.of(classes.split(",")).map(it -> {
            try {
                return loader.loadClass((String)it);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't load '" + it + "'", e);
            }
        }).toArray(Class[]::new);
        this.addClassesDeploymentUrl();
        BeanArchiveService beanArchiveService = webBeansContext.getBeanArchiveService();
        this.archive = new CdiArchive(beanArchiveService, WebBeansUtil.getCurrentClassLoader(), Collections.emptyMap(), null, this.getAdditionalArchive());
        Map.Entry<String, URL> deplUrl = this.getBeanDeploymentUrls().entrySet().iterator().next();
        this.archive.classesByUrl().put(deplUrl.getKey(), new CdiArchive.FoundClasses(deplUrl.getValue(), Stream.of(classes.split(",")).collect(Collectors.toList()), beanArchiveService.getBeanArchiveInformation(deplUrl.getValue())));
        this.finder = new OwbAnnotationFinder(reflectClasses);
        return this.finder;
    }

    @Override
    public void classes(Class<?>[] classes) {
    }

    @Override
    public void packages(boolean recursive, Class<?>[] markers) {
    }

    @Override
    public void packages(boolean recursive, Package[] packages) {
    }
}

