/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.response;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLSession;

public class StaticHttpResponse<T>
implements HttpResponse<T> {
    private final HttpRequest request;
    private final int statusCode;
    private final HttpHeaders headers;
    private final T body;
    private final URI uri;
    private final HttpClient.Version version;

    public StaticHttpResponse(HttpRequest request, URI uri, HttpClient.Version version, int statusCode, HttpHeaders headers, T body) {
        this.request = request;
        this.uri = uri;
        this.version = version;
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    public StaticHttpResponse(HttpRequest request, HttpClient.Version version, int statusCode, HttpHeaders headers, T body) {
        this(request, request.uri(), version, statusCode, headers, body);
    }

    public StaticHttpResponse(HttpRequest request, int statusCode, HttpHeaders headers, T body) {
        this(request, request.uri(), HttpClient.Version.HTTP_1_1, statusCode, headers, body);
    }

    public StaticHttpResponse(HttpRequest request, int statusCode, T body) {
        this(request, request.uri(), HttpClient.Version.HTTP_1_1, statusCode, Constants.NO_HEADER, body);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public Optional<HttpResponse<T>> previousResponse() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Optional.empty();
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    private static class Constants {
        private static final HttpHeaders NO_HEADER = HttpHeaders.of(Map.of(), (a, b) -> true);

        private Constants() {
        }
    }
}

