/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.replay;

import io.yupiik.uship.httpclient.core.DelegatingHttpClient;
import io.yupiik.uship.httpclient.core.listener.impl.BaseHARDumperListener;
import io.yupiik.uship.httpclient.core.replay.HARHelper;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

public class NDJSONHttpClient
extends DelegatingHttpClient.Synchronous
implements AutoCloseable {
    private final Jsonb jsonb;
    private final BufferedReader stream;
    private final HARHelper helper = new HARHelper();

    public NDJSONHttpClient(Configuration configuration) {
        super(configuration.httpClient);
        this.jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().setProperty("johnzon.skip-cdi", (Object)true));
        try {
            this.stream = Files.newBufferedReader(configuration.input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        String line = this.nextLine();
        if (line == null) {
            if (this.delegate == null) {
                throw new IllegalStateException("No response for " + request);
            }
            return super.send(request, responseBodyHandler);
        }
        return this.helper.toResponse(request, responseBodyHandler, this.readLine(line));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        String line;
        try {
            line = this.nextLine();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (line == null) {
            if (this.delegate == null) {
                throw new IllegalStateException("No response for " + request);
            }
            return super.sendAsync(request, handler);
        }
        try {
            return CompletableFuture.completedFuture(this.helper.toResponse(request, handler, this.readLine(line)));
        }
        catch (RuntimeException re) {
            CompletableFuture<HttpResponse<T>> future = new CompletableFuture<HttpResponse<T>>();
            future.completeExceptionally(re);
            return future;
        }
    }

    private BaseHARDumperListener.Har.Entry readLine(String line) {
        return (BaseHARDumperListener.Har.Entry)this.jsonb.fromJson(line.strip(), BaseHARDumperListener.Har.Entry.class);
    }

    private synchronized String nextLine() throws IOException {
        String line;
        while ((line = this.stream.readLine()) != null && line.isBlank()) {
        }
        return line;
    }

    @Override
    public void close() throws Exception {
        this.jsonb.close();
        this.stream.close();
    }

    public static class Configuration {
        private final HttpClient httpClient;
        private final Path input;

        public Configuration(HttpClient httpClient, Path input) {
            this.httpClient = httpClient;
            this.input = input;
        }

        public Configuration(Path input) {
            this(null, input);
        }
    }
}

