/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.replay;

import io.yupiik.uship.httpclient.core.DelegatingHttpClient;
import io.yupiik.uship.httpclient.core.listener.impl.BaseHARDumperListener;
import io.yupiik.uship.httpclient.core.replay.HARHelper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public class HARHttpClient
extends DelegatingHttpClient.Synchronous {
    private final Iterator<BaseHARDumperListener.Har.Entry> iterator;
    private final HARHelper helper = new HARHelper();

    public HARHttpClient(Configuration configuration) {
        super(configuration.httpClient);
        this.iterator = configuration.har.log.entries.iterator();
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        BaseHARDumperListener.Har.Entry next = this.nextEntry();
        if (next == null) {
            if (this.delegate == null) {
                throw new IllegalStateException("No response for " + request);
            }
            return super.sendAsync(request, handler);
        }
        try {
            return CompletableFuture.completedFuture(this.helper.toResponse(request, handler, next));
        }
        catch (RuntimeException re) {
            CompletableFuture<HttpResponse<T>> future = new CompletableFuture<HttpResponse<T>>();
            future.completeExceptionally(re);
            return future;
        }
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        BaseHARDumperListener.Har.Entry next = this.nextEntry();
        if (next == null) {
            if (this.delegate == null) {
                throw new IllegalStateException("No response for " + request);
            }
            return super.send(request, responseBodyHandler);
        }
        return this.helper.toResponse(request, responseBodyHandler, next);
    }

    private synchronized BaseHARDumperListener.Har.Entry nextEntry() {
        return this.iterator.hasNext() ? this.iterator.next() : null;
    }

    public static class Configuration {
        private final HttpClient httpClient;
        private final BaseHARDumperListener.Har har;

        public Configuration(HttpClient httpClient, BaseHARDumperListener.Har har) {
            this.httpClient = httpClient;
            this.har = har;
        }

        public Configuration(BaseHARDumperListener.Har har) {
            this(null, har);
        }
    }
}

