/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.replay;

import io.yupiik.uship.httpclient.core.listener.impl.BaseHARDumperListener;
import io.yupiik.uship.httpclient.core.response.StaticHttpResponse;
import io.yupiik.uship.httpclient.core.response.StaticResponseInfo;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class HARHelper {
    HARHelper() {
    }

    public <T> StaticHttpResponse<T> toResponse(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, BaseHARDumperListener.Har.Entry inMemory) {
        StaticResponseInfo info = new StaticResponseInfo(inMemory.response.status, this.readHeaders(inMemory), this.httpVersion(inMemory.response.httpVersion));
        return new StaticHttpResponse<T>(request, info.version(), info.statusCode(), info.headers(), this.readBody((HttpResponse.ResponseInfo)info, inMemory.response, responseBodyHandler));
    }

    private HttpClient.Version httpVersion(String version) {
        return version != null && version.startsWith("HTTP/2.") ? HttpClient.Version.HTTP_2 : HttpClient.Version.HTTP_1_1;
    }

    private HttpHeaders readHeaders(BaseHARDumperListener.Har.Entry inMemory) {
        return HttpHeaders.of(inMemory.response.headers == null ? Map.of() : inMemory.response.headers.stream().collect(Collectors.toMap(h -> h.name, h -> List.of(h.value), (a, b) -> Stream.of(a, b).flatMap(Collection::stream).collect(Collectors.toList()))), (a, b) -> true);
    }

    private <T> T readBody(HttpResponse.ResponseInfo info, BaseHARDumperListener.Har.Response response, HttpResponse.BodyHandler<T> handler) {
        if (response.content != null) {
            if (response.content.text != null) {
                return this.readBody(info, response.content.text.getBytes(StandardCharsets.UTF_8), handler);
            }
            if (response.content.encoding != null) {
                return this.readBody(info, Base64.getDecoder().decode(response.content.encoding), handler);
            }
        }
        return null;
    }

    private <T> T readBody(HttpResponse.ResponseInfo info, byte[] text, HttpResponse.BodyHandler<T> handler) {
        HttpResponse.BodySubscriber<List<ByteBuffer>> subscriber = handler.apply(info);
        try {
            subscriber.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                }

                @Override
                public void cancel() {
                }
            });
            subscriber.onNext(List.of(ByteBuffer.wrap(text)));
            subscriber.onComplete();
        }
        catch (RuntimeException re) {
            subscriber.onError(re);
        }
        try {
            return subscriber.getBody().toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }
}

