/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.listener.impl;

import io.yupiik.uship.httpclient.core.listener.impl.BaseHARDumperListener;
import jakarta.json.bind.Jsonb;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.logging.Logger;

public class NDJSONDumperListener
extends BaseHARDumperListener
implements AutoCloseable {
    private final BufferedWriter stream;
    private final Jsonb jsonb;
    private final boolean flush;

    public NDJSONDumperListener(Configuration configuration) {
        super(configuration);
        this.flush = configuration.flushOnEachEntry;
        if (configuration.output.getParent() != null) {
            try {
                Files.createDirectories(configuration.output.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            this.stream = Files.newBufferedWriter(configuration.output, new OpenOption[0]);
            this.jsonb = this.newJsonb();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected boolean isJsonFormatted() {
        return false;
    }

    @Override
    public void close() throws Exception {
        this.stream.close();
        this.jsonb.close();
        this.configuration.logger.info(() -> "Dumped ND-JSON to '" + this.configuration.output + "'");
    }

    @Override
    protected synchronized void onEntry(BaseHARDumperListener.Har.Entry entry) {
        try {
            this.stream.write(this.jsonb.toJson((Object)entry) + "\n");
            if (this.flush) {
                this.stream.flush();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public static class Configuration
    extends BaseHARDumperListener.BaseConfiguration<Configuration> {
        private boolean flushOnEachEntry = true;

        public Configuration(Path output, Clock clock, Logger logger) {
            super(output, clock, logger);
        }

        public Configuration setFlushOnEachEntry(boolean flushOnEachEntry) {
            this.flushOnEachEntry = flushOnEachEntry;
            return this;
        }
    }
}

