/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.listener.impl;

import io.yupiik.uship.httpclient.core.listener.impl.BaseHARDumperListener;
import jakarta.json.bind.Jsonb;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class HARDumperListener
extends BaseHARDumperListener
implements AutoCloseable {
    private final Har har = new Har();

    public HARDumperListener(Path output, Clock clock, Logger logger) {
        this(new Configuration(output, clock, logger));
    }

    public HARDumperListener(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected boolean isJsonFormatted() {
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.har.log.entries == null) {
            this.configuration.logger.info(() -> "No HAR to dump, skipping writing '" + this.configuration.output + "'");
        }
        if (this.configuration.output.getParent() != null) {
            Files.createDirectories(this.configuration.output.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.configuration.output, new OpenOption[0]);
             Jsonb jsonb = this.newJsonb();){
            jsonb.toJson((Object)this.har, (Writer)writer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.configuration.logger.info(() -> "Dumped HAR to '" + this.configuration.output + "'");
    }

    public Har getHar() {
        return this.har;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntry(BaseHARDumperListener.Har.Entry entry) {
        if (this.har.log.entries == null) {
            Har har = this.har;
            synchronized (har) {
                if (this.har.log.entries == null) {
                    this.har.log.entries = new CopyOnWriteArrayList<BaseHARDumperListener.Har.Entry>();
                }
            }
        }
        this.har.log.entries.add(entry);
    }

    public static class Configuration
    extends BaseHARDumperListener.BaseConfiguration<Configuration> {
        public Configuration(Path output, Clock clock, Logger logger) {
            super(output, clock, logger);
        }
    }

    public static class Har
    extends BaseHARDumperListener.Har {
    }
}

