/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.listener.impl;

import io.yupiik.uship.httpclient.core.listener.RequestListener;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FilteringListener<A>
implements RequestListener<State<A>>,
AutoCloseable {
    private final State<A> skippedState = new State(null, true);
    private final Configuration<A> configuration;

    public FilteringListener(Configuration<A> configuration) {
        this.configuration = configuration;
    }

    private boolean isSkipped(HttpRequest request) {
        return this.configuration.ignoredMethods.contains(request.method()) || this.configuration.ignoredPaths.stream().anyMatch(it -> it.test(request.uri().getPath()));
    }

    private boolean isSkipped(Throwable error, HttpResponse<?> response) {
        if (error != null) {
            return this.configuration.skipExceptions;
        }
        int status = response.statusCode();
        return status < this.configuration.minimumStatus || status > this.configuration.maximumStatus;
    }

    @Override
    public RequestListener.State<State<A>> before(long count, HttpRequest request) {
        boolean skip = this.isSkipped(request);
        if (skip) {
            return new RequestListener.State<State<A>>(request, this.skippedState);
        }
        RequestListener.State state = this.configuration.delegate.before(count, request);
        return new RequestListener.State<State<A>>(state.request(), new State(state, false));
    }

    @Override
    public void after(State<A> state, HttpRequest request, Throwable error, HttpResponse<?> response) {
        if (!state.skip && !this.isSkipped(error, response)) {
            this.configuration.delegate.after(state.value.state(), state.value.request(), error, response);
        }
    }

    @Override
    public void close() throws Exception {
        if (AutoCloseable.class.isInstance(this.configuration.delegate)) {
            ((AutoCloseable)AutoCloseable.class.cast(this.configuration.delegate)).close();
        }
    }

    public static class State<T> {
        private final RequestListener.State<T> value;
        private final boolean skip;

        private State(RequestListener.State<T> value, boolean skip) {
            this.value = value;
            this.skip = skip;
        }
    }

    public static class Configuration<T> {
        private final RequestListener<T> delegate;
        private List<String> ignoredMethods = List.of();
        private List<Predicate<String>> ignoredPaths = List.of();
        private boolean skipExceptions = false;
        private int minimumStatus = 0;
        private int maximumStatus = 1000;

        public Configuration(RequestListener<T> delegate) {
            this.delegate = delegate;
        }

        public Configuration<T> setIgnoredPaths(List<String> ignoredPaths) {
            this.ignoredPaths = ignoredPaths.stream().map(it -> it.startsWith("regex:") ? Pattern.compile(it.substring("regex:".length())).asMatchPredicate() : it::equals).collect(Collectors.toList());
            return this;
        }

        public Configuration<T> setIgnoredMethods(List<String> ignoredMethods) {
            this.ignoredMethods = ignoredMethods;
            return this;
        }

        public Configuration<T> setSkipExceptions(boolean skipExceptions) {
            this.skipExceptions = skipExceptions;
            return this;
        }

        public Configuration<T> setMinimumStatus(int minimumStatus) {
            this.minimumStatus = minimumStatus;
            return this;
        }

        public Configuration<T> setMaximumStatus(int maximumStatus) {
            this.maximumStatus = maximumStatus;
            return this;
        }
    }
}

