/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.listener.impl;

import io.yupiik.uship.httpclient.core.listener.RequestListener;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Clock;
import java.time.Instant;
import java.util.logging.Logger;

public class ExchangeLogger
implements RequestListener<Data> {
    private final Logger logger;
    private final Clock clock;
    private final boolean logPayload;

    public ExchangeLogger(Logger logger, Clock clock, boolean logPayload) {
        this.logger = logger;
        this.clock = clock;
        this.logPayload = logPayload;
    }

    @Override
    public RequestListener.State<Data> before(long count, HttpRequest request) {
        return new RequestListener.State<Data>(request, new Data(count, this.clock.instant()));
    }

    @Override
    public void after(Data before, HttpRequest request, Throwable error, HttpResponse<?> response) {
        this.logger.info(() -> this.toLogMessage(before, request, error, response));
    }

    protected String toLogMessage(Data before, HttpRequest request, Throwable error, HttpResponse<?> response) {
        return "#" + before.count + ", Request: '" + request.method() + " " + request.uri() + "' took " + this.clock.instant().minusMillis(before.instant.toEpochMilli()).toEpochMilli() + "ms\nResponse: " + (error != null ? "[ERROR] " + error.getMessage() : "HTTP " + response.statusCode()) + (String)(this.logPayload ? "\nPayload:\n" + response.body() : "");
    }

    protected static class Data {
        private final long count;
        private final Instant instant;

        protected Data(long count, Instant instant) {
            this.count = count;
            this.instant = instant;
        }
    }
}

