/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.uship.httpclient.core.listener.impl;

import io.yupiik.uship.httpclient.core.listener.RequestListener;
import io.yupiik.uship.httpclient.core.request.UnlockedHttpRequest;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.annotation.JsonbDateFormat;
import java.io.IOException;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseHARDumperListener
implements RequestListener<Data> {
    protected final BaseConfiguration configuration;

    public BaseHARDumperListener(BaseConfiguration configuration) {
        this.configuration = configuration;
    }

    protected abstract void onEntry(Har.Entry var1);

    protected abstract boolean isJsonFormatted();

    protected Jsonb newJsonb() {
        return JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(this.isJsonFormatted())).withPropertyOrderStrategy("LEXICOGRAPHICAL").setProperty("johnzon.skip-cdi", (Object)true));
    }

    @Override
    public RequestListener.State<Data> before(long count, HttpRequest request) {
        byte[] requestPayload = this.readRequestPayload(request);
        if (requestPayload == null) {
            return new RequestListener.State<Data>(request, new Data(this.configuration.clock.instant(), null));
        }
        return new RequestListener.State<Data>(new UnlockedHttpRequest(Optional.of(HttpRequest.BodyPublishers.ofByteArray(requestPayload)), request.method(), request.timeout(), request.expectContinue(), request.uri(), request.version(), request.headers()), new Data(this.configuration.clock.instant(), requestPayload));
    }

    @Override
    public void after(Data state, HttpRequest request, Throwable error, HttpResponse<?> response) {
        Har.Entry entry = new Har.Entry();
        entry.request = this.toRequest(request, state.requestPayload);
        entry.response = this.toResponse(response);
        if (this.configuration.enableStartedDateTime) {
            entry.startedDateTime = state.instant.atZone(this.configuration.clock.getZone());
        }
        if (this.configuration.enableTime) {
            entry.time = Duration.between(state.instant, this.configuration.clock.instant()).toMillis();
        }
        this.onEntry(entry);
    }

    private Har.Request toRequest(HttpRequest request, byte[] body) {
        Har.Request req = new Har.Request();
        if (body != null) {
            req.bodySize = body.length;
            Har.PostData postData = new Har.PostData();
            request.headers().firstValue("Content-Type").ifPresent(contentType -> {
                postData.mimeType = contentType;
                if (contentType.contains("form")) {
                    postData.params = Stream.of(new String(body, StandardCharsets.UTF_8).split("&")).map(it -> {
                        int eq = it.indexOf(61);
                        Har.Param param = new Har.Param();
                        if (eq > 0) {
                            param.name = it.substring(0, eq);
                            param.value = it.substring(eq + 1);
                        } else {
                            param.name = it;
                            param.value = "";
                        }
                        return param;
                    }).collect(Collectors.toList());
                } else {
                    postData.text = new String(body, StandardCharsets.UTF_8);
                }
            });
            if (postData.params == null && postData.text == null) {
                postData.text = new String(body, StandardCharsets.UTF_8);
            }
            req.postData = postData;
        } else {
            req.bodySize = -1L;
        }
        req.method = request.method();
        req.url = request.uri().toASCIIString();
        req.queryString = Optional.ofNullable(request.uri().getQuery()).filter(it -> !it.isBlank()).map(q -> {
            req.url = req.url.replace("?" + q, "");
            return q;
        }).map(query -> Stream.of(query.split("&")).map(it -> {
            int eq = it.indexOf(61);
            if (eq > 0) {
                return new String[]{it.substring(0, eq), it.substring(eq + 1)};
            }
            return new String[]{it, ""};
        }).map(arr -> {
            Har.Query q = new Har.Query();
            q.name = arr[0];
            q.value = arr[1];
            return q;
        }).collect(Collectors.toList())).orElse(null);
        req.headers = this.toHeaders(request.headers());
        req.headerSize = this.toHeaderSize(req.headers);
        return req;
    }

    private Har.Response toResponse(HttpResponse<?> response) {
        Object body;
        Har.Response harResponse = new Har.Response();
        if (CharSequence.class.isInstance(response.body())) {
            body = String.valueOf(response.body()).getBytes(StandardCharsets.UTF_8);
            this.setContentFromBody(response, harResponse, (byte[])body);
        } else if (byte[].class.isInstance(response.body())) {
            body = (byte[])byte[].class.cast(response.body());
            this.setContentFromBody(response, harResponse, (byte[])body);
        } else if (Path.class.isInstance(response.body())) {
            body = (Path)Path.class.cast(response.body());
            try {
                this.setContentFromBody(response, harResponse, Files.readAllBytes((Path)body));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            if (response.body() != null) {
                throw new IllegalArgumentException("Unsupported HAR support for body: " + response.body());
            }
            harResponse.bodySize = -1L;
        }
        HttpHeaders headers = response.headers();
        harResponse.status = response.statusCode();
        if (harResponse.status == 301 || harResponse.status == 302 || harResponse.status == 303 || harResponse.status == 308) {
            harResponse.redirectURL = headers.firstValue("Location").orElse(null);
        }
        harResponse.headers = this.toHeaders(headers);
        harResponse.headersSize = this.toHeaderSize(harResponse.headers);
        return harResponse;
    }

    private long toHeaderSize(Collection<Har.Header> headers) {
        return headers.stream().mapToLong(h -> h.name.getBytes(StandardCharsets.UTF_8).length + h.value.getBytes(StandardCharsets.UTF_8).length + ": \r\n".length()).sum();
    }

    private Collection<Har.Header> toHeaders(HttpHeaders headers) {
        return headers == null ? List.of() : (Collection)headers.map().entrySet().stream().map(it -> {
            Har.Header header = new Har.Header();
            header.name = (String)it.getKey();
            header.value = String.join((CharSequence)",", (Iterable)it.getValue());
            return header;
        }).collect(Collectors.toList());
    }

    private void setContentFromBody(HttpResponse<?> response, Har.Response harResponse, byte[] body) {
        harResponse.bodySize = body == null ? -1L : (long)body.length;
        Har.Content content = new Har.Content();
        content.size = harResponse.bodySize;
        harResponse.content = content;
        if (harResponse.bodySize >= 0L && response.headers() != null) {
            response.headers().firstValue("Content-Type").ifPresent(contentType -> {
                content.mimeType = contentType;
                if (List.of("application/octet-stream", "multipart/form-data").contains(contentType) || contentType.startsWith("application/vnd.openxmlformats-officedocument")) {
                    content.encoding = "base64";
                    content.text = Base64.getEncoder().encodeToString(body);
                }
            });
            if (content.text == null) {
                content.text = new String(body, StandardCharsets.UTF_8);
            }
        }
    }

    private byte[] readRequestPayload(HttpRequest request) {
        return request.bodyPublisher().map(p -> {
            if (p.contentLength() == 0L) {
                return null;
            }
            final HttpResponse.BodySubscriber<byte[]> subscriber = HttpResponse.BodySubscribers.ofByteArray();
            p.subscribe(new Flow.Subscriber<ByteBuffer>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    subscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(ByteBuffer item) {
                    subscriber.onNext(List.of(item));
                }

                @Override
                public void onError(Throwable throwable) {
                    subscriber.onError(throwable);
                }

                @Override
                public void onComplete() {
                    subscriber.onComplete();
                }
            });
            try {
                return subscriber.getBody().toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }).orElse(null);
    }

    public static class BaseConfiguration<T extends BaseConfiguration> {
        protected final Path output;
        protected final Clock clock;
        protected final Logger logger;
        private boolean enableStartedDateTime = true;
        private boolean enableTime = true;

        protected BaseConfiguration(Path output, Clock clock, Logger logger) {
            this.output = output;
            this.clock = clock;
            this.logger = logger;
        }

        public boolean isEnableStartedDateTime() {
            return this.enableStartedDateTime;
        }

        public T setEnableStartedDateTime(boolean enableStartedDateTime) {
            this.enableStartedDateTime = enableStartedDateTime;
            return (T)this;
        }

        public boolean isEnableTime() {
            return this.enableTime;
        }

        public T setEnableTime(boolean enableTime) {
            this.enableTime = enableTime;
            return (T)this;
        }
    }

    public static class Har {
        private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
        public Log log = new Log();

        public static class Browser
        extends BaseIdentity {
        }

        public static class Creator
        extends BaseIdentity {
        }

        public static abstract class BaseIdentity {
            public String name;
            public String version;
            public String comment = "";
        }

        public static class PageTiming {
            public long onContentLoad;
            public long onLoad;
            public String comment;
        }

        public static class Page {
            @JsonbDateFormat(value="yyyy-MM-dd'T'HH:mm:ss.SSSX")
            public ZonedDateTime startedDateTime;
            public String id;
            public String title;
            public PageTiming pageTimings;
            public String comment = "";
        }

        public static class Entry {
            @JsonbDateFormat(value="yyyy-MM-dd'T'HH:mm:ss.SSSX")
            public ZonedDateTime startedDateTime;
            public String pageref;
            public long time;
            public Request request;
            public Response response;
            public Cache cache;
            public Timings timings;
            public String serverIPAddress;
            public String connection;
            public String comment;
        }

        public static class Content {
            public long size;
            public int compression;
            public String mimeType;
            public String text;
            public String encoding;
            public String comment;
        }

        public static class Header {
            public String name;
            public String value;
            public String comment;
        }

        public static class Cookie {
            @JsonbDateFormat(value="yyyy-MM-dd'T'HH:mm:ss.SSSX")
            public ZonedDateTime expires;
            public String name;
            public String value;
            public String path;
            public String domain;
            public boolean httpOnly;
            public boolean secure;
            public String comment;
        }

        public static class Timings {
            public long blocked = -1L;
            public long dns = -1L;
            public long connect = -1L;
            public long send = 0L;
            public long wait = 0L;
            public long receive = 0L;
            public long ssl = -1L;
            public String comment = "";
        }

        public static class AfterRequest
        extends CacheRequest {
        }

        public static class BeforeRequest
        extends CacheRequest {
        }

        public static abstract class CacheRequest {
            @JsonbDateFormat(value="yyyy-MM-dd'T'HH:mm:ss.SSSX")
            public ZonedDateTime expires;
            @JsonbDateFormat(value="yyyy-MM-dd'T'HH:mm:ss.SSSX")
            public ZonedDateTime lastAccess;
            public String eTag;
            public int hitCount;
            public String comment;
        }

        public static class Cache {
            public BeforeRequest beforeRequest;
            public AfterRequest afterRequest;
            public String comment = "";
        }

        public static class Param {
            public String name;
            public String value;
            public String fileName;
            public String contentType;
            public String comment = "";
        }

        public static class PostData {
            public String mimeType;
            public Collection<Param> params;
            public String text;
            public String comment = "";
        }

        public static class Query {
            public String name;
            public String value;
            public String comment = "";
        }

        public static class Response {
            public int status = 200;
            public String statusText = "OK";
            public String httpVersion = "HTTP/1.1";
            public Collection<Cookie> cookies;
            public Collection<Header> headers;
            public Content content;
            public String redirectURL;
            public long headersSize;
            public long bodySize;
            public String comment = "";
        }

        public static class Request {
            public String method;
            public String url;
            public String httpVersion = "HTTP/1.1";
            public Collection<Cookie> cookies;
            public Collection<Header> headers;
            public Collection<Query> queryString;
            public PostData postData;
            public long headerSize = -1L;
            public long bodySize;
            public String comment = "";
        }

        public static class Log {
            public String version = "1.2";
            public Creator creator;
            public Browser browser;
            public Collection<Page> pages;
            public Collection<Entry> entries;
            public String comment = "";
        }
    }

    protected static class Data {
        private final Instant instant;
        private final byte[] requestPayload;

        protected Data(Instant instant, byte[] requestPayload) {
            this.instant = instant;
            this.requestPayload = requestPayload;
        }
    }
}

